/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.AnyDefNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.AssumeNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefOrLabelNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.TheoremNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import util.UniqueString;
import util.WrongInvocationException;

public class ThmOrAssumpDefNode
extends SymbolNode
implements OpDefOrLabelNode,
AnyDefNode {
    protected LevelNode thmOrAssump = null;
    private LevelNode body = null;
    private ModuleNode originallyDefinedInModule = null;
    private boolean theorem = true;
    private boolean suffices = false;
    private Hashtable<UniqueString, LabelNode> labels = null;
    public int arity = 0;
    private FormalParamNode[] params = new FormalParamNode[0];
    ProofNode proof;
    private ModuleNode instantiatedFrom = null;
    private ThmOrAssumpDefNode source = null;
    private boolean local = false;
    int[] maxLevels;
    int[] weights;
    int[][] minMaxLevel;
    boolean[] isLeibnizArg;
    boolean isLeibniz;
    private boolean[][][] opLevelCond;

    public Hashtable<UniqueString, LabelNode> getLabelsHT() {
        return this.labels;
    }

    @Override
    public ThmOrAssumpDefNode getSource() {
        if (this.source == null) {
            return this;
        }
        return this.source;
    }

    public ThmOrAssumpDefNode(UniqueString name, boolean thm, LevelNode exp, ModuleNode oModNode, SymbolTable st, TreeNode stn, FormalParamNode[] parms, ModuleNode iFrom, ThmOrAssumpDefNode src) {
        super(23, stn, name);
        this.theorem = thm;
        this.body = exp;
        this.originallyDefinedInModule = oModNode;
        this.instantiatedFrom = iFrom;
        this.source = src;
        if (st != null) {
            st.addSymbol(name, this);
        }
        if (parms != null) {
            this.params = parms;
            this.arity = parms.length;
        }
    }

    public ThmOrAssumpDefNode(UniqueString name, TreeNode stn) {
        super(23, stn, name);
    }

    public void construct(boolean thm, LevelNode exp, ModuleNode oModNode, SymbolTable st, FormalParamNode[] parms) {
        this.theorem = thm;
        this.body = exp;
        this.originallyDefinedInModule = oModNode;
        if (st != null) {
            st.addSymbol(this.name, this);
        }
        if (parms != null) {
            this.params = parms;
            this.arity = parms.length;
        }
    }

    public LevelNode getBody() {
        return this.body;
    }

    public ModuleNode getOriginallyDefinedInModuleNode() {
        return this.originallyDefinedInModule;
    }

    public ModuleNode getInstantiatedFrom() {
        return this.instantiatedFrom;
    }

    public boolean isTheorem() {
        return this.theorem;
    }

    public boolean isSuffices() {
        return this.suffices;
    }

    void setSuffices() {
        this.suffices = true;
    }

    public final ProofNode getProof() {
        return this.proof;
    }

    @Override
    public final FormalParamNode[] getParams() {
        return this.params;
    }

    public final boolean isExpr() {
        return this.body instanceof ExprNode;
    }

    @Override
    public final int getArity() {
        return this.arity;
    }

    @Override
    public final boolean isLocal() {
        return this.local;
    }

    public final void setLocal(boolean localness) {
        this.local = localness;
    }

    @Override
    public final boolean match(OpApplNode test, ModuleNode mn) {
        SymbolNode odn = test.getOperator();
        return odn.getArity() == 0;
    }

    @Override
    public void setLabels(Hashtable<UniqueString, LabelNode> ht) {
        this.labels = ht;
    }

    @Override
    public LabelNode getLabel(UniqueString us) {
        if (this.labels == null) {
            return null;
        }
        return this.labels.get(us);
    }

    @Override
    public boolean addLabel(LabelNode odn) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (this.labels.containsKey(odn.getName())) {
            return false;
        }
        this.labels.put(odn.getName(), odn);
        return true;
    }

    @Override
    public LabelNode[] getLabels() {
        if (this.labels == null) {
            return new LabelNode[0];
        }
        Vector<LabelNode> v = new Vector<LabelNode>();
        Enumeration<LabelNode> e = this.labels.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        LabelNode[] retVal = new LabelNode[v.size()];
        int i = 0;
        while (i < v.size()) {
            retVal[i] = (LabelNode)v.elementAt(i);
            ++i;
        }
        return retVal;
    }

    @Override
    public boolean[] getIsLeibnizArg() {
        return this.isLeibnizArg;
    }

    @Override
    public boolean getIsLeibniz() {
        return this.isLeibniz;
    }

    @Override
    public final boolean levelCheck(int itr) {
        int j;
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.maxLevels = new int[this.params.length];
        this.weights = new int[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            this.maxLevels[i] = 3;
            this.weights[i] = 0;
            this.isLeibniz = true;
            this.isLeibnizArg = new boolean[this.params.length];
            this.isLeibnizArg[i] = true;
            ++i;
        }
        this.levelCorrect = this.body.levelCheck(itr);
        this.level = this.body.getLevel();
        SetOfLevelConstraints lcSet = this.body.getLevelConstraints();
        int i2 = 0;
        while (i2 < this.params.length) {
            Object plevel = lcSet.get(this.params[i2]);
            if (plevel != null) {
                this.maxLevels[i2] = (Integer)plevel;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.params.length) {
            if (this.body.getLevelParams().contains(this.params[i2])) {
                this.weights[i2] = this.weights[i2];
            }
            ++i2;
        }
        this.minMaxLevel = new int[this.params.length][];
        SetOfArgLevelConstraints alcSet = this.body.getArgLevelConstraints();
        int i3 = 0;
        while (i3 < this.params.length) {
            int alen = this.params[i3].getArity();
            this.minMaxLevel[i3] = new int[alen];
            j = 0;
            while (j < alen) {
                Object alevel = alcSet.get(new ParamAndPosition(this.params[i3], j));
                this.minMaxLevel[i3][j] = alevel == null ? 0 : (Integer)alevel;
                ++j;
            }
            ++i3;
        }
        this.opLevelCond = new boolean[this.params.length][this.params.length][];
        HashSet<ArgLevelParam> alpSet = this.body.getArgLevelParams();
        int i4 = 0;
        while (i4 < this.params.length) {
            j = 0;
            while (j < this.params.length) {
                this.opLevelCond[i4][j] = new boolean[this.params[i4].getArity()];
                int k = 0;
                while (k < this.params[i4].getArity()) {
                    ArgLevelParam alp = new ArgLevelParam(this.params[i4], k, this.params[j]);
                    this.opLevelCond[i4][j][k] = alpSet.contains(alp);
                    ++k;
                }
                ++j;
            }
            ++i4;
        }
        this.levelParams.addAll(this.body.getLevelParams());
        this.allParams.addAll(this.body.getAllParams());
        this.nonLeibnizParams.addAll(this.body.getNonLeibnizParams());
        i4 = 0;
        while (i4 < this.params.length) {
            this.levelParams.remove(this.params[i4]);
            this.allParams.remove(this.params[i4]);
            if (this.nonLeibnizParams.contains(this.params[i4])) {
                this.nonLeibnizParams.remove(this.params[i4]);
                this.isLeibnizArg[i4] = false;
                this.isLeibniz = false;
            }
            ++i4;
        }
        this.levelConstraints = (SetOfLevelConstraints)lcSet.clone();
        i4 = 0;
        while (i4 < this.params.length) {
            this.levelConstraints.remove(this.params[i4]);
            ++i4;
        }
        this.argLevelConstraints = (SetOfArgLevelConstraints)alcSet.clone();
        i4 = 0;
        while (i4 < this.params.length) {
            int alen = this.params[i4].getArity();
            int j2 = 0;
            while (j2 < alen) {
                this.argLevelConstraints.remove(new ParamAndPosition(this.params[i4], j2));
                ++j2;
            }
            ++i4;
        }
        for (ArgLevelParam alp : alpSet) {
            if (alp.op.occur(this.params) && alp.param.occur(this.params)) continue;
            this.argLevelParams.add(alp);
        }
        return this.levelCorrect;
    }

    @Override
    public final int getMaxLevel(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMaxLevel called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.maxLevels[idx];
    }

    @Override
    public final int getWeight(int i) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getWeight called before levelCheck");
        }
        int idx = this.getArity() == -1 ? 0 : i;
        return this.weights[idx];
    }

    @Override
    public final int getMinMaxLevel(int i, int j) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getMinMaxLevel called before levelCheck");
        }
        if (this.minMaxLevel == null) {
            return 0;
        }
        return this.minMaxLevel[i][j];
    }

    @Override
    public final boolean getOpLevelCond(int i, int j, int k) {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getOpLevelCond called before levelCheck");
        }
        if (this.opLevelCond == null) {
            return false;
        }
        return this.opLevelCond[i][j][k];
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.body};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.body != null) {
            this.body.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*ThmOrAssumpDefNode: " + this.getName().toString() + "  " + super.toString(depth) + " arity: " + this.arity + " module: " + (this.originallyDefinedInModule != null ? this.originallyDefinedInModule.getName().toString() : "<null>");
        if (this.instantiatedFrom != null) {
            ret = String.valueOf(ret) + " instantiatedFrom: " + this.instantiatedFrom.getName();
        }
        if (this.params != null) {
            String tempString = "\nFormal params: " + this.params.length;
            int i = 0;
            while (i < this.params.length) {
                tempString = String.valueOf(tempString) + Strings.indent(2, this.params[i] != null ? this.params[i].toString(depth - 1) : "\nnull");
                ++i;
            }
            ret = String.valueOf(ret) + Strings.indent(2, tempString);
        }
        if (this.body != null) {
            ret = String.valueOf(ret) + Strings.indent(2, "\nisTheorem(): " + this.theorem + "\nBody:" + Strings.indent(2, this.body.toString(depth - 1)) + "\nsuffices: " + this.isSuffices());
        }
        if (this.labels != null) {
            ret = String.valueOf(ret) + "\n  Labels: ";
            Enumeration<UniqueString> list = this.labels.keys();
            while (list.hasMoreElements()) {
                ret = String.valueOf(ret) + list.nextElement().toString() + "  ";
            }
        } else {
            ret = String.valueOf(ret) + "\n  Labels: null";
        }
        return ret;
    }

    @Override
    protected String getNodeRef() {
        if (this.theorem) {
            assert (this.thmOrAssump instanceof TheoremNode);
            return "TheoremDefRef";
        }
        assert (this.thmOrAssump instanceof AssumeNode);
        return "AssumeDefRef";
    }

    @Override
    protected Element getSymbolElement(Document doc, SymbolContext context) {
        assert (this.body != null);
        Element e = null;
        e = this.theorem ? doc.createElement("TheoremDefNode") : doc.createElement("AssumeDef");
        e.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
        e.appendChild(this.body.export(doc, context));
        return e;
    }

    @Override
    public Element export(Document doc, SymbolContext context) {
        context.put(this, doc);
        Element e = doc.createElement(this.getNodeRef());
        e.appendChild(this.appendText(doc, "UID", Integer.toString(this.myUID)));
        return e;
    }
}

