/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.IOException;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStates;
import tlc2.tool.queue.DiskByteArrayQueue;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.FlightRecorderProfiler;

@State(value=Scope.Group)
@BenchmarkMode(value={Mode.Throughput})
public class DiskQueueBenachmark {
    @Param(value={"1", "2", "4", "8", "16", "32", "64"})
    public int vars;
    @Param(value={"DiskByteArrayQueue", "DiskStateQueue"})
    public String impl;
    private IStateQueue dsq;
    private TLCState state;

    @Setup
    public void up() throws IOException {
        this.dsq = this.impl.equals("DiskByteArrayQueue") ? new DiskByteArrayQueue() : new DiskStateQueue();
        this.state = TLCStates.createDummyState(this.vars);
    }

    @TearDown
    public void down() throws IOException {
        this.dsq.delete();
    }

    @Benchmark
    @Group(value="g02")
    @GroupThreads(value=1)
    public TLCState consumer1() {
        return this.dsq.sDequeue();
    }

    @Benchmark
    @Group(value="g02")
    @GroupThreads(value=1)
    public void producer1() {
        this.dsq.sEnqueue(this.state);
    }

    @Benchmark
    @Group(value="g04")
    @GroupThreads(value=2)
    public TLCState consumer2() {
        return this.dsq.sDequeue();
    }

    @Benchmark
    @Group(value="g04")
    @GroupThreads(value=2)
    public void producer2() {
        this.dsq.sEnqueue(this.state);
    }

    @Benchmark
    @Group(value="g08")
    @GroupThreads(value=4)
    public TLCState consumer4() {
        return this.dsq.sDequeue();
    }

    @Benchmark
    @Group(value="g08")
    @GroupThreads(value=4)
    public void producer4() {
        this.dsq.sEnqueue(this.state);
    }

    @Benchmark
    @Group(value="g16")
    @GroupThreads(value=8)
    public TLCState consumer8() {
        return this.dsq.sDequeue();
    }

    @Benchmark
    @Group(value="g16")
    @GroupThreads(value=8)
    public void producer8() {
        this.dsq.sEnqueue(this.state);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(DiskQueueBenachmark.class.getSimpleName()).addProfiler(FlightRecorderProfiler.class).build();
        new Runner(opt).run();
    }
}

