/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Random;
import org.junit.Before;
import org.junit.Test;
import tlc2.util.BigInt;
import tlc2.util.ByteUtils;
import util.ToolIO;

public class ByteUtilsTest {
    public static final int ARRAYSIZE = 10000;
    public static final int BITS = 1000;
    private File testFileB;
    private File testFileA;
    BigInteger[] Arr;
    BigInteger[] Arr2;
    BigInteger[] Arr3;
    BigInteger[] Arr4;
    BigInteger[] Arr5;
    long t1;
    long t2;

    @Before
    public void setUp() throws Exception {
        this.Arr = new BigInteger[10000];
        this.Arr2 = new BigInteger[10000];
        this.Arr3 = new BigInteger[10000];
        this.Arr4 = new BigInteger[10000];
        this.Arr5 = new BigInteger[10000];
        this.testFileA = File.createTempFile("ByteUtilsTestA", null);
        this.testFileA.deleteOnExit();
        this.testFileB = File.createTempFile("ByteUtilsTestB", null);
        this.testFileB.deleteOnExit();
    }

    @Test
    public void test1() {
        this.t1 = System.currentTimeMillis();
        this.mainTestinttoByte();
        this.t2 = System.currentTimeMillis();
        ToolIO.out.println("Testing IntToByteArray took " + (this.t2 - this.t1) + "ms");
    }

    @Test
    public void test2() throws FileNotFoundException, IOException {
        this.t1 = System.currentTimeMillis();
        this.mainTestWriteIntReadInt();
        this.t2 = System.currentTimeMillis();
        ToolIO.out.println("Testing WriteInt, ReadInt took " + (this.t2 - this.t1) + "ms");
    }

    @Test
    public void test3() {
        this.t1 = System.currentTimeMillis();
        this.mainTestlongtoByte();
        this.t2 = System.currentTimeMillis();
        ToolIO.out.println("Testing longToByteArray took " + (this.t2 - this.t1) + "ms");
    }

    @Test
    public void test4() throws FileNotFoundException, IOException {
        this.t1 = System.currentTimeMillis();
        this.mainTestWriteLongReadLong();
        this.t2 = System.currentTimeMillis();
        ToolIO.out.println("Testing WriteLong, ReadLong took " + (this.t2 - this.t1) + "ms");
    }

    @Test
    public void test5() throws FileNotFoundException, IOException {
        this.t1 = System.currentTimeMillis();
        this.mainTestWriteReadSizeByteArray();
        this.t2 = System.currentTimeMillis();
        ToolIO.out.println("Testing Write, Read took " + (this.t2 - this.t1) + "ms");
    }

    @Test
    public void test6() throws FileNotFoundException, IOException {
        this.t1 = System.currentTimeMillis();
        this.mainTestAppend();
        this.t2 = System.currentTimeMillis();
        ToolIO.out.println("Testing Append took " + (this.t2 - this.t1) + "ms");
    }

    private void mainTestinttoByte() {
        Random r = new Random();
        int j = 0;
        while (j < 10000) {
            byte[] b;
            int i = r.nextInt();
            if (i != ByteUtils.byteArrayToInt(b = ByteUtils.intToByteArray(i)) || b.length != 4) {
                ToolIO.out.println("i :" + i + "    byte :" + b + "    i: " + ByteUtils.byteArrayToInt(b) + "    size: " + b.length);
            }
            ++j;
        }
    }

    private void mainTestWriteIntReadInt() throws IOException, FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(this.testFileA);
        int[] A = new int[10000];
        Random r = new Random();
        int j = 0;
        while (j < 10000) {
            A[j] = r.nextInt();
            ByteUtils.writeInt(fout, A[j]);
            ++j;
        }
        fout.flush();
        fout.close();
        FileInputStream fin = new FileInputStream(this.testFileA);
        j = 0;
        while (j < 10000) {
            int i = ByteUtils.readInt(fin);
            if (i != A[j]) {
                ToolIO.out.println("i :" + i + "   A[j]: " + A[j]);
            }
            ++j;
        }
    }

    private void mainTestlongtoByte() {
        Random r = new Random();
        long j = 0L;
        while (j < 10000L) {
            byte[] b;
            long i = r.nextLong();
            if (i != ByteUtils.byteArrayToLong(b = ByteUtils.longToByteArray(i)) || b.length != 8) {
                ToolIO.out.println("i :" + i + "    byte :" + b + "    i: " + ByteUtils.byteArrayToLong(b) + "    size: " + b.length);
            }
            ++j;
        }
    }

    private void mainTestWriteLongReadLong() throws IOException, FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(this.testFileA);
        long[] A = new long[10000];
        Random r = new Random();
        int j = 0;
        while (j < 10000) {
            A[j] = r.nextLong();
            ByteUtils.writeLong(fout, A[j]);
            ++j;
        }
        fout.close();
        FileInputStream fin = new FileInputStream(this.testFileA);
        j = 0;
        while (j < 10000) {
            long i = ByteUtils.readLong(fin);
            if (i != A[j]) {
                ToolIO.out.println("i :" + i + "   A[j]: " + A[j]);
            }
            ++j;
        }
    }

    private void mainTestWriteReadSizeByteArray() throws IOException, FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(this.testFileA);
        BigInt[] A = new BigInt[10000];
        BigInt[] B = new BigInt[10000];
        this.mainInitialize(A, B);
        int half = 4999;
        ByteUtils.writeSizeArrayOfSizeBigInts(A, 0, half - 1, fout);
        ByteUtils.writeSizeArrayOfSizeBigInts(A, half, 9999, fout);
        fout.flush();
        fout.close();
        FileInputStream fin = new FileInputStream(this.testFileA);
        B = ByteUtils.readSizeArrayOfSizeBigInts(fin);
        ByteUtils.readInt(fin);
        BigInt[] C = ByteUtils.readArrayOfSizeBigInts(fin);
        int j = 0;
        while (j < half) {
            if (!A[j].equals(B[j])) {
                ToolIO.out.println("A[" + j + "] :" + A[j] + "   B[" + j + "]: " + B[j]);
            }
            ++j;
        }
        j = half;
        while (j < 10000) {
            if (!A[j].equals(C[j - half])) {
                ToolIO.out.println("A[" + j + "] :" + A[j] + "   C[" + (j - half) + "]: " + C[j - half]);
            }
            ++j;
        }
    }

    private void mainTestAppend() throws IOException, FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(this.testFileA);
        BigInt[] A = new BigInt[10000];
        BigInt[] B = new BigInt[10000];
        this.mainInitialize(A, B);
        int half = 4999;
        ByteUtils.writeSizeArrayOfSizeBigInts(A, 0, half - 1, fout);
        ByteUtils.writeSizeArrayOfSizeBigInts(A, half, 9999, fout);
        fout.flush();
        fout.close();
        FileInputStream fin = new FileInputStream(this.testFileA);
        fout = new FileOutputStream(this.testFileB);
        try {
            ByteUtils.appendSizeByteArray(fin, fout);
            ByteUtils.appendSizeByteArray(fin, fout);
            ByteUtils.appendSizeByteArray(fin, fout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fin.close();
        fout.flush();
        fout.close();
        fin = new FileInputStream(this.testFileB);
        B = ByteUtils.readSizeArrayOfSizeBigInts(fin);
        ByteUtils.readInt(fin);
        BigInt[] C = ByteUtils.readArrayOfSizeBigInts(fin);
        int j = 0;
        while (j < half) {
            if (!A[j].equals(B[j])) {
                ToolIO.out.println("A[" + j + "] :" + A[j] + "   B[" + j + "]: " + B[j]);
            }
            ++j;
        }
        j = half;
        while (j < 10000) {
            if (!A[j].equals(C[j - half])) {
                ToolIO.out.println("A[" + j + "] :" + A[j] + "   C[" + (j - half) + "]: " + C[j - half]);
            }
            ++j;
        }
    }

    private void mainInitialize(BigInt[] Arr, BigInt[] Arr2) {
        Random r = new Random();
        int i = 0;
        while (i < 10000) {
            Arr[i] = new BigInt(1000, r);
            Arr2[i] = Arr[i];
            ++i;
        }
    }
}

