/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import tlc2.util.FP64;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.SubsetValue;

@State(value=Scope.Benchmark)
public class SubsetBenchmark {
    @Param(value={"10", "12", "14", "16", "20", "24"})
    public int numOfElements;
    @Param(value={"32", "64", "128", "256"})
    public int size;
    public SubsetValue subset;

    static {
        RandomEnumerableValues.setSeed(15041980L);
        RandomEnumerableValues.reset();
        FP64.Init();
    }

    @Setup(value=Level.Invocation)
    public void setup() {
        if (this.size < 128 || this.size >= 128 && this.numOfElements <= 20) {
            this.subset = (SubsetValue)new SubsetValue(new IntervalValue(1, this.size)).normalize();
        } else {
            System.exit(0);
        }
    }

    @Benchmark
    public Enumerable randomSetOfSubsets() {
        return this.subset.getRandomSetOfSubsets(1 << this.numOfElements, 0.1);
    }

    @Benchmark
    public Enumerable randomSetOfSubsetsExact() {
        return this.subset.getRandomSetOfSubsets(1 << this.numOfElements, 10);
    }
}

