/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.drivers;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import tla2sany.configuration.Configuration;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.InitException;
import tla2sany.drivers.SemanticException;
import tla2sany.explorer.Explorer;
import tla2sany.explorer.ExplorerQuitException;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.parser.ParseException;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.BuiltInLevel;
import tla2sany.semantic.Context;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.Generator;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import util.FileUtil;
import util.ToolIO;
import util.UniqueString;
import util.UsageGenerator;

public class SANY {
    private static String modDate = "08 July 2020";
    public static String version = "Version 2.2 created " + modDate;
    private static boolean doParsing = true;
    private static boolean doSemanticAnalysis = true;
    private static boolean doLevelChecking = true;
    private static boolean doDebugging = false;
    private static boolean doStats = false;
    private static boolean doStrictErrorCodes = false;

    public static final int frontEndMain(SpecObj spec2, String fileName, PrintStream syserr) throws FrontEndException {
        try {
            SANY.frontEndInitialize(spec2, syserr);
            if (doParsing) {
                SANY.frontEndParse(spec2, syserr);
            }
            if (doSemanticAnalysis) {
                SANY.frontEndSemanticAnalysis(spec2, syserr, doLevelChecking);
            }
        }
        catch (InitException ie) {
            return -1;
        }
        catch (ParseException pe) {
            return -1;
        }
        catch (SemanticException se) {
            return -1;
        }
        catch (Exception e) {
            syserr.println(e.toString());
            throw new FrontEndException(e);
        }
        if (doStrictErrorCodes) {
            return spec2.errorLevel;
        }
        return 0;
    }

    public static void frontEndInitialize(SpecObj spec2, PrintStream syserr) throws InitException {
        String fileName = spec2.getFileName();
        Errors initErrors = spec2.initErrors;
        try {
            Configuration.ReInit();
            Context.reInit();
            Configuration.load(initErrors);
            BuiltInLevel.load();
            if (!initErrors.isSuccess()) {
                syserr.println("*** Errors during initialization of SANY:\n");
                syserr.print(initErrors);
                spec2.errorLevel = 1;
                throw new InitException();
            }
        }
        catch (Exception e) {
            syserr.println("Unexpected exception during SANY initialization " + fileName + "\n" + e);
            syserr.println("Initialization errors detected before the unexpected exception:\n");
            syserr.print(initErrors);
            spec2.errorLevel = 1;
            throw new InitException();
        }
    }

    public static void frontEndParse(SpecObj spec2, PrintStream syserr) throws ParseException {
        SANY.frontEndParse(spec2, syserr, true);
    }

    public static void frontEndParse(SpecObj spec2, PrintStream syserr, boolean validatePCalTranslation) throws ParseException {
        try {
            if (!spec2.loadSpec(spec2.getFileName(), spec2.parseErrors, validatePCalTranslation)) {
                // empty if block
            }
            if (!spec2.parseErrors.isSuccess()) {
                if (syserr != null) {
                    syserr.println(spec2.parseErrors);
                }
                spec2.errorLevel = 2;
                throw new ParseException();
            }
        }
        catch (ParseException e) {
            throw new ParseException();
        }
        catch (Exception e) {
            syserr.println("\nFatal errors while parsing TLA+ spec in file " + spec2.getFileName() + "\n");
            syserr.println(e.toString());
            syserr.print(spec2.parseErrors);
            throw new ParseException();
        }
    }

    public static void frontEndSemanticAnalysis(SpecObj spec2, PrintStream syserr, boolean levelCheck) throws SemanticException {
        ExternalModuleTable externalModuleTable = spec2.getExternalModuleTable();
        ModuleNode moduleNode = null;
        Errors semanticErrors = spec2.semanticErrors;
        Errors globalContextErrors = Context.getGlobalContext().getErrors();
        try {
            SemanticNode.setError(semanticErrors);
            for (int i = 0; i < spec2.semanticAnalysisVector.size(); ++i) {
                String moduleStringName = (String)spec2.semanticAnalysisVector.elementAt(i);
                if (externalModuleTable.getContext(UniqueString.uniqueStringOf(moduleStringName)) != null) continue;
                ParseUnit parseUnit = spec2.parseUnitContext.get(moduleStringName);
                TreeNode syntaxTreeRoot = parseUnit.getParseTree();
                syserr.println("Semantic processing of module " + moduleStringName);
                Generator gen = new Generator(externalModuleTable, semanticErrors);
                moduleNode = gen.generate(syntaxTreeRoot);
                moduleNode.setStandard(spec2.getResolver().isStandardModule(moduleStringName));
                externalModuleTable.put(UniqueString.uniqueStringOf(moduleStringName), gen.getSymbolTable().getExternalContext(), moduleNode);
                if (moduleNode != null && semanticErrors.isSuccess() && levelCheck) {
                    moduleNode.levelCheck(1);
                }
                if (i == spec2.semanticAnalysisVector.size() - 1) {
                    externalModuleTable.setRootModule(moduleNode);
                }
                if (globalContextErrors.getNumMessages() > 0) {
                    syserr.println("Semantic errors in global context:\n");
                    syserr.print("\n" + globalContextErrors);
                    spec2.errorLevel = 3;
                    spec2.setGlobalContextErrors(globalContextErrors);
                }
                if (semanticErrors.getNumMessages() <= 0) continue;
                syserr.println("Semantic errors:\n\n" + semanticErrors);
                if (semanticErrors.getNumAbortsAndErrors() <= 0) continue;
                spec2.errorLevel = 4;
            }
        }
        catch (AbortException e) {
            if (syserr != null) {
                syserr.println("Fatal errors in semantic processing of TLA spec " + spec2.getFileName() + "\n" + e.getMessage() + "\nStack trace for exception:\n");
                e.printStackTrace(syserr);
            }
            if (globalContextErrors.getNumMessages() > 0) {
                if (syserr != null) {
                    syserr.println("Semantic errors in global context detected before the unexpected exception:\n");
                    syserr.print("\n" + globalContextErrors);
                }
                spec2.errorLevel = 3;
            }
            if (semanticErrors.getNumMessages() > 0) {
                if (syserr != null) {
                    syserr.println("Semantic errors detected before the unexpected exception:\n");
                    syserr.print("\n" + semanticErrors);
                }
                if (semanticErrors.getNumAbortsAndErrors() > 0) {
                    spec2.errorLevel = 4;
                }
            }
            throw new SemanticException();
        }
    }

    public static final void frontEndStatistics(SpecObj spec2) {
    }

    private static void printUsage() {
        ArrayList<List<UsageGenerator.Argument>> commandVariants = new ArrayList<List<UsageGenerator.Argument>>();
        ArrayList<UsageGenerator.Argument> variant = new ArrayList<UsageGenerator.Argument>();
        variant.add(new UsageGenerator.Argument("-s", "Turns off semantic analysis", true));
        commandVariants.add(variant);
        variant.add(new UsageGenerator.Argument("-l", "Turns off level checking. Level checking won't be\nused, if the semantic analysis is disabled. ", true));
        variant.add(new UsageGenerator.Argument("-stat", "Turns off reporting statistics about builtin operator\nusage.", true));
        variant.add(new UsageGenerator.Argument("-error-codes", "If enabled, error level will be reported as the tools'\nreturn value.", true));
        commandVariants.add(variant);
        ArrayList<String> tips = new ArrayList<String>();
        UsageGenerator.displayUsage(ToolIO.out, "SANY", version, "provides parsing, semantic analysis, and level-checking for a TLA+ spec", "SANY is a parser and syntax checker for TLA+ specifications.\nIt catches parsing errors and some \"semantic\" errors such as\npriming an expression containing primed variables.", commandVariants, tips, ' ');
    }

    public static void SANYmain(String[] args) {
        int i;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("-S") || args[i].equals("-s")) {
                doSemanticAnalysis = !doSemanticAnalysis;
                continue;
            }
            if (args[i].equals("-L") || args[i].equals("-l")) {
                doLevelChecking = !doLevelChecking;
                continue;
            }
            if (args[i].equals("-D") || args[i].equals("-d")) {
                doDebugging = !doDebugging;
                continue;
            }
            if (args[i].equals("-STAT") || args[i].equals("-stat")) {
                doStats = !doStats;
                continue;
            }
            if (args[i].toLowerCase().equals("-error-codes")) {
                doStrictErrorCodes = true;
                continue;
            }
            if (args[i].toLowerCase().equals("-help")) {
                SANY.printUsage();
                System.exit(0);
                continue;
            }
            ToolIO.out.println("Command-line error: " + args[i]);
            ToolIO.out.println("Use -help option for more information.");
            System.exit(-1);
        }
        while (i < args.length) {
            ToolIO.out.println("\n****** SANY2 " + version + "\n");
            SpecObj spec2 = new SpecObj(args[i], null);
            if (FileUtil.createNamedInputStream(args[i], spec2.getResolver()) != null) {
                try {
                    int ret = SANY.frontEndMain(spec2, args[i], ToolIO.out);
                    if (ret != 0) {
                        System.exit(ret);
                    }
                }
                catch (FrontEndException fe) {
                    fe.printStackTrace();
                    ToolIO.out.println(fe);
                    System.exit(-1);
                }
                if (doStats) {
                    SANY.frontEndStatistics(spec2);
                }
                if (doDebugging) {
                    Explorer explorer = new Explorer(spec2.getExternalModuleTable());
                    try {
                        explorer.main(args);
                    }
                    catch (ExplorerQuitException explorerQuitException) {}
                }
            } else {
                ToolIO.out.println("Cannot find the specified file " + args[i] + ".");
                System.exit(-1);
            }
            ++i;
        }
    }
}

