/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import tlc2.REPLSpecWriter;
import tlc2.TLCGlobals;
import tlc2.TLCRunner;
import tlc2.TraceExpressionExplorerSpecWriter;
import tlc2.input.MCOutputParser;
import tlc2.input.MCOutputPipeConsumer;
import tlc2.input.MCParser;
import tlc2.input.MCParserResults;
import tlc2.model.MCError;
import tlc2.model.MCState;
import tlc2.output.CFGCopier;
import tlc2.output.MP;
import tlc2.output.Messages;
import tlc2.output.SpecTraceExpressionWriter;
import tlc2.output.TLACopier;
import tlc2.util.Vect;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import util.ToolIO;
import util.UsageGenerator;

public class TraceExplorer {
    private static final String GENERATE_SPEC_FUNCTION_PARAMETER_NAME = "-generateSpecTE";
    private static final String PRETTY_PRINT_FUNCTION_PARAMETER_NAME = "-prettyPrint";
    private static final String QUASI_REPL_PARAMETER_NAME = "-replBis";
    private static final String TRACE_EXPRESSIONS_FUNCTION_PARAMETER_NAME = "-traceExpressions";
    private static final String EXPRESSIONS_FILE_PARAMETER_NAME = "-expressionsFile";
    private static final String MODEL_CHECK_JVM_ARGUMENTS_PARAMETER_NAME = "-jvmArguments";
    private static final String MODEL_CHECK_TLC_ARGUMENTS_PARAMETER_NAME = "-tlcArguments";
    private static final String SOURCE_DIR_PARAMETER_NAME = "-source";
    private static final String GENERATE_SPEC_OVERWRITE_PARAMETER_NAME = "-overwrite";
    static final String SPEC_TE_INIT_ID = "_SpecTEInit";
    static final String SPEC_TE_NEXT_ID = "_SpecTENext";
    private static final String SPEC_TE_ACTION_CONSTRAINT_ID = "_SpecTEActionConstraint";
    private static final HashMap<String, Boolean> TLC_ARGUMENTS_TO_IGNORE = new HashMap();
    private File specGenerationSourceDirectory;
    private String specGenerationOriginalSpecName;
    private boolean expectedOutputFromStdIn;
    private boolean overwriteGeneratedFiles;
    private List<String> expressions;
    private List<String> tlcArguments;
    private String replSpecName;
    private File temporaryREPLSpec;
    private RunMode runMode;

    public static File[] writeSpecTEFiles(File sourceDirectory, String originalSpecName, MCParserResults results, MCError error) throws IOException {
        StringBuilder tlaBuffer = new StringBuilder();
        StringBuilder cfgBuffer = new StringBuilder();
        Vect configDeclaredConstants = results.getModelConfig().getConstants();
        HashSet<String> constantModelValuesToDeclare = new HashSet<String>();
        int constantsCount = configDeclaredConstants.size();
        for (int i = 0; i < constantsCount; ++i) {
            Vect vect = (Vect)configDeclaredConstants.elementAt(i);
            Object value = vect.elementAt(1);
            if (!(value instanceof SetEnumValue)) continue;
            SetEnumValue sev = (SetEnumValue)value;
            ValueEnumeration ve = sev.elements();
            Value v = ve.nextElement();
            while (v != null) {
                constantModelValuesToDeclare.add(v.toString());
                v = ve.nextElement();
            }
        }
        if (constantModelValuesToDeclare.size() > 0) {
            cfgBuffer.append("CONSTANTS").append("\n");
            for (String string2 : constantModelValuesToDeclare) {
                cfgBuffer.append("    ").append(string2).append(" = ");
                cfgBuffer.append(string2).append("\n");
            }
            cfgBuffer.append("\n");
            tlaBuffer.append("\n").append("CONSTANTS").append(' ');
            boolean firstDone = false;
            for (String modelValue : constantModelValuesToDeclare) {
                if (firstDone) {
                    tlaBuffer.append(", ");
                } else {
                    firstDone = true;
                }
                tlaBuffer.append(modelValue);
            }
            tlaBuffer.append("\n").append("\n");
        }
        List<MCState> trace = error.getStates();
        StringBuilder[] stringBuilderArray = SpecTraceExpressionWriter.addInitNextToBuffers(cfgBuffer, trace, null, SPEC_TE_INIT_ID, SPEC_TE_NEXT_ID, SPEC_TE_ACTION_CONSTRAINT_ID, results.getOriginalNextOrSpecificationName(), true);
        tlaBuffer.append(stringBuilderArray[0].toString());
        SpecTraceExpressionWriter.addTraceFunctionToBuffers(tlaBuffer, cfgBuffer, trace);
        tlaBuffer.append(stringBuilderArray[1].toString());
        List<String> extendedModules = results.getOriginalExtendedModules();
        boolean specExtendsTLC = extendedModules.contains("TLC");
        boolean specExtendsToolbox = extendedModules.contains("Toolbox");
        TLACopier tlaCopier = new TLACopier(originalSpecName, "SpecTE", sourceDirectory, tlaBuffer.toString(), specExtendsTLC, specExtendsToolbox);
        tlaCopier.copy();
        MP.printMessage(1000, "The file " + tlaCopier.getDestinationFile().getAbsolutePath() + " has been created.");
        CFGCopier cfgCopier = new CFGCopier(originalSpecName, "SpecTE", sourceDirectory, cfgBuffer.toString());
        cfgCopier.copy();
        MP.printMessage(1000, "The file " + cfgCopier.getDestinationFile().getAbsolutePath() + " has been created.");
        return new File[]{tlaCopier.getDestinationFile(), cfgCopier.getDestinationFile()};
    }

    public TraceExplorer(String[] commandLineArguments) {
        this.processArguments(commandLineArguments);
        if (this.runMode == null) {
            TraceExplorer.printUsageAndExit();
        }
    }

    protected final void processArguments(String[] args) {
        File f;
        this.runMode = this.determineRunModeFromArguments(args);
        if (this.runMode == null) {
            return;
        }
        switch (this.runMode) {
            case QUASI_REPL: 
            case TRACE_EXPLORATION: {
                this.tlcArguments = new ArrayList<String>();
                break;
            }
        }
        this.specGenerationSourceDirectory = new File(System.getProperty("user.dir"));
        this.specGenerationOriginalSpecName = args[args.length - 1];
        boolean bl = this.expectedOutputFromStdIn = this.specGenerationOriginalSpecName.charAt(0) == '-';
        if (this.expectedOutputFromStdIn) {
            this.specGenerationOriginalSpecName = null;
        } else if (RunMode.QUASI_REPL.equals((Object)this.runMode)) {
            TraceExplorer.printUsageAndExit();
        }
        this.overwriteGeneratedFiles = false;
        String expressionsSourceFilename = null;
        boolean consumedAdditionalParameters = true;
        int upperIndex = this.expectedOutputFromStdIn ? args.length : args.length - 1;
        int index2 = 0;
        while (consumedAdditionalParameters) {
            if (index2 < upperIndex) {
                String[] arguments;
                String argumentList;
                String nextArg = args[index2];
                if (this.getRunModeForArgument(nextArg) != null) {
                    ++index2;
                    continue;
                }
                if (SOURCE_DIR_PARAMETER_NAME.equals(nextArg)) {
                    int n = ++index2;
                    ++index2;
                    String runDirectory = args[n];
                    f = new File(runDirectory);
                    if (!f.exists()) {
                        this.printErrorMessage("specified source directory does not exist.");
                        return;
                    }
                    if (!f.isDirectory()) {
                        this.printErrorMessage("specified source directory is not a directory.");
                        return;
                    }
                    this.specGenerationSourceDirectory = f;
                    ++index2;
                    continue;
                }
                if (GENERATE_SPEC_OVERWRITE_PARAMETER_NAME.equals(nextArg)) {
                    this.overwriteGeneratedFiles = true;
                    ++index2;
                    continue;
                }
                if (EXPRESSIONS_FILE_PARAMETER_NAME.equals(nextArg)) {
                    int n = ++index2;
                    ++index2;
                    expressionsSourceFilename = args[n];
                    continue;
                }
                if (MODEL_CHECK_JVM_ARGUMENTS_PARAMETER_NAME.equals(nextArg)) {
                    int n = ++index2;
                    ++index2;
                    argumentList = args[n];
                    arguments = argumentList.split(" ");
                    TLCRunner.JVM_ARGUMENTS.addAll(Arrays.asList(arguments));
                    continue;
                }
                if (MODEL_CHECK_TLC_ARGUMENTS_PARAMETER_NAME.equals(nextArg)) {
                    int n = ++index2;
                    ++index2;
                    argumentList = args[n];
                    arguments = argumentList.split(" ");
                    for (int argIndex = 0; argIndex < arguments.length; ++argIndex) {
                        String argument = arguments[argIndex];
                        Boolean ignoreAdditionalParameter = TLC_ARGUMENTS_TO_IGNORE.get(argument);
                        if (ignoreAdditionalParameter == null) {
                            this.tlcArguments.add(argument);
                            continue;
                        }
                        if (!ignoreAdditionalParameter.booleanValue()) continue;
                        ++argIndex;
                    }
                    continue;
                }
                consumedAdditionalParameters = false;
                continue;
            }
            consumedAdditionalParameters = false;
        }
        if (RunMode.TRACE_EXPLORATION.equals((Object)this.runMode) || RunMode.QUASI_REPL.equals((Object)this.runMode)) {
            if (expressionsSourceFilename == null) {
                this.printErrorMessage("no expressions file specified.");
                this.runMode = null;
                return;
            }
            File sourceDirFile = new File(this.specGenerationSourceDirectory, expressionsSourceFilename);
            File absoluteFile = new File(expressionsSourceFilename);
            if (sourceDirFile.exists()) {
                f = sourceDirFile;
            } else if (absoluteFile.exists()) {
                f = absoluteFile;
            } else {
                String errorMessageSuffix = sourceDirFile.getAbsolutePath().equals(absoluteFile.getAbsolutePath()) ? sourceDirFile.getAbsolutePath() : sourceDirFile.getAbsolutePath() + " nor " + absoluteFile.getAbsolutePath();
                this.printErrorMessage("an expressions file could not be found at " + errorMessageSuffix);
                this.runMode = null;
                return;
            }
            try {
                this.expressions = new ArrayList<String>();
                try (BufferedReader br = new BufferedReader(new FileReader(f));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        String trimmed = line.trim();
                        if (trimmed.length() <= 0) continue;
                        this.expressions.add(trimmed);
                    }
                }
            }
            catch (IOException e2) {
                this.printErrorMessage("encountered an exception reading from expressions file " + f.getAbsolutePath() + " :: " + e2.getMessage());
                this.runMode = null;
                return;
            }
            if (RunMode.TRACE_EXPLORATION.equals((Object)this.runMode)) {
                this.tlcArguments.add("-config");
                this.tlcArguments.add("TE.cfg");
                this.tlcArguments.add("-tool");
            } else {
                this.replSpecName = "repl";
                this.temporaryREPLSpec = new File(this.specGenerationSourceDirectory, this.replSpecName + ".tla");
                this.temporaryREPLSpec.deleteOnExit();
            }
            this.tlcArguments.add("-metadir");
            this.tlcArguments.add(this.specGenerationSourceDirectory.getAbsolutePath());
            if (RunMode.TRACE_EXPLORATION.equals((Object)this.runMode)) {
                this.tlcArguments.add("TE");
            } else {
                this.tlcArguments.add(this.replSpecName);
            }
        }
    }

    public int execute() throws Exception {
        if (RunMode.QUASI_REPL.equals((Object)this.runMode)) {
            return this.performREPL();
        }
        if (this.expectedOutputFromStdIn) {
            return this.executeStreaming();
        }
        return this.executeNonStreaming();
    }

    private RunMode determineRunModeFromArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            RunMode rm = this.getRunModeForArgument(args[i]);
            if (rm == null) continue;
            return rm;
        }
        return null;
    }

    private RunMode getRunModeForArgument(String arg) {
        if (GENERATE_SPEC_FUNCTION_PARAMETER_NAME.equals(arg)) {
            return RunMode.GENERATE_SPEC_TE;
        }
        if (PRETTY_PRINT_FUNCTION_PARAMETER_NAME.equals(arg)) {
            return RunMode.PRETTY_PRINT;
        }
        if (TRACE_EXPRESSIONS_FUNCTION_PARAMETER_NAME.equals(arg)) {
            return RunMode.TRACE_EXPLORATION;
        }
        if (QUASI_REPL_PARAMETER_NAME.equals(arg)) {
            return RunMode.QUASI_REPL;
        }
        return null;
    }

    private int executeNonStreaming() throws Exception {
        boolean needGenerateSpecTE;
        if (!this.performPreFlightFileChecks()) {
            throw new IllegalStateException("There was an issue with the input, SpecTE, or TE file.");
        }
        boolean specifiedModuleIsSpecTE = this.specGenerationOriginalSpecName.equals("SpecTE");
        boolean bl = needGenerateSpecTE = RunMode.GENERATE_SPEC_TE.equals((Object)this.runMode) || !specifiedModuleIsSpecTE && RunMode.TRACE_EXPLORATION.equals((Object)this.runMode);
        if (needGenerateSpecTE) {
            MCParser parser = new MCParser(this.specGenerationSourceDirectory, this.specGenerationOriginalSpecName);
            MCParserResults results = parser.parse();
            if (results.getOutputMessages().size() == 0) {
                MP.printMessage(1000, "The output file had no tool messages; was TLC not run with the '-tool' option when producing it?");
                return 255;
            }
            if (results.getError() == null) {
                String msg = RunMode.GENERATE_SPEC_TE.equals((Object)this.runMode) ? "The output file contained no error-state messages, no SpecTE will be produced." : "The output file contained no error-state messages, no SpecTE nor TE will be produced, and, so, no trace expressions will be evaluated.";
                MP.printMessage(1000, msg);
                return 0;
            }
            try {
                this.writeSpecTEFiles(results, results.getError());
                if (RunMode.GENERATE_SPEC_TE.equals((Object)this.runMode)) {
                    return 0;
                }
                if (RunMode.TRACE_EXPLORATION.equals((Object)this.runMode)) {
                    return this.performTraceExploration();
                }
            }
            catch (Exception exception) {}
        } else if (RunMode.PRETTY_PRINT.equals((Object)this.runMode)) {
            try {
                MCOutputParser.prettyPrintToStream((OutputStream)System.out, this.specGenerationSourceDirectory, this.specGenerationOriginalSpecName);
                return 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 255;
    }

    private int executeStreaming() throws Exception {
        boolean needGenerateSpecTE;
        final AtomicBoolean mcParserCompleted = new AtomicBoolean(false);
        final ReentrantLock parseLock = new ReentrantLock();
        final ArrayList parserList = new ArrayList(1);
        MCOutputPipeConsumer.ConsumerLifespanListener listener = new MCOutputPipeConsumer.ConsumerLifespanListener(){

            @Override
            public void consumptionFoundSourceDirectoryAndSpecName(MCOutputPipeConsumer consumer) {
                boolean needGenerateSpecTE;
                TraceExplorer.this.specGenerationSourceDirectory = consumer.getSourceDirectory();
                TraceExplorer.this.specGenerationOriginalSpecName = consumer.getSpecName();
                boolean specifiedModuleIsSpecTE = TraceExplorer.this.specGenerationOriginalSpecName.equals("SpecTE");
                boolean bl = needGenerateSpecTE = RunMode.GENERATE_SPEC_TE.equals((Object)TraceExplorer.this.runMode) || !specifiedModuleIsSpecTE && RunMode.TRACE_EXPLORATION.equals((Object)TraceExplorer.this.runMode);
                if (!TraceExplorer.this.performPreFlightFileChecks()) {
                    throw new IllegalStateException("There was an issue with the input, SpecTE, or TE file.");
                }
                if (needGenerateSpecTE) {
                    MP.printMessage(1000, "Have encountered the source spec in the output logging, will begin parsing of those assets now.");
                    Runnable r = () -> {
                        MCParser parser = new MCParser(TraceExplorer.this.specGenerationSourceDirectory, TraceExplorer.this.specGenerationOriginalSpecName, true);
                        parserList.add(parser);
                        parseLock.lock();
                        try {
                            parser.parse();
                        }
                        finally {
                            mcParserCompleted.set(true);
                            parseLock.unlock();
                        }
                    };
                    new Thread(r).start();
                }
            }
        };
        MCOutputPipeConsumer pipeConsumer = new MCOutputPipeConsumer(System.in, listener);
        MP.printMessage(1000, "TraceExplorer is expecting input on stdin...");
        pipeConsumer.consumeOutput(false);
        if (pipeConsumer.outputHadNoToolMessages()) {
            MP.printMessage(1000, "The output had no tool messages; was TLC not run with the '-tool' option when producing it?");
            return 255;
        }
        MP.printMessage(1000, "Have received the final output logging message - finishing TraceExplorer work.");
        boolean specifiedModuleIsSpecTE = this.specGenerationOriginalSpecName.equals("SpecTE");
        boolean bl = needGenerateSpecTE = RunMode.GENERATE_SPEC_TE.equals((Object)this.runMode) || !specifiedModuleIsSpecTE && RunMode.TRACE_EXPLORATION.equals((Object)this.runMode);
        if (needGenerateSpecTE) {
            if (pipeConsumer.getError() == null) {
                String msg = RunMode.GENERATE_SPEC_TE.equals((Object)this.runMode) ? "The output contained no error-state messages, no SpecTE will be produced." : "The output contained no error-state messages, no SpecTE nor TE will be produced, and, so, no trace expressions will be evaluated.";
                MP.printMessage(1000, msg);
                return 0;
            }
            if (!mcParserCompleted.get()) {
                parseLock.lock();
            }
            MCParserResults results = ((MCParser)parserList.get(0)).getParseResults();
            try {
                this.writeSpecTEFiles(results, pipeConsumer.getError());
                if (RunMode.GENERATE_SPEC_TE.equals((Object)this.runMode)) {
                    return 0;
                }
                if (RunMode.TRACE_EXPLORATION.equals((Object)this.runMode)) {
                    return this.performTraceExploration();
                }
            }
            catch (Exception exception) {}
        } else if (RunMode.PRETTY_PRINT.equals((Object)this.runMode)) {
            if (pipeConsumer.getError() == null) {
                MP.printMessage(1000, "The output contained no error-state messages; there is nothing to display.");
                return 0;
            }
            try {
                MCOutputParser.prettyPrintToStream(System.out, pipeConsumer.getError());
                return 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 255;
    }

    private int performREPL() throws IOException {
        REPLSpecWriter writer2 = new REPLSpecWriter(this.replSpecName, this.expressions);
        File cfgFile = new File(this.specGenerationSourceDirectory, this.replSpecName + ".cfg");
        cfgFile.deleteOnExit();
        writer2.writeFiles(this.temporaryREPLSpec, cfgFile);
        REPLSpecWriter.REPLLogConsumerStream outputStream = new REPLSpecWriter.REPLLogConsumerStream();
        TLCRunner tlcRunner = new TLCRunner(this.tlcArguments, outputStream);
        tlcRunner.setSilenceStdOut(true);
        int errorCode = tlcRunner.run();
        System.out.println(String.join((CharSequence)"\n", this.expressions));
        System.out.println("\t = ");
        System.out.println("\t\t" + outputStream.getCollectedContent());
        return errorCode;
    }

    private int performTraceExploration() throws IOException {
        File tlaFile = new File(this.specGenerationSourceDirectory, "TE.tla");
        TraceExpressionExplorerSpecWriter writer2 = new TraceExpressionExplorerSpecWriter(this.expressions);
        String configContent = writer2.getConfigBuffer().toString();
        writer2.writeFiles(tlaFile, null);
        CFGCopier cfgCopier = new CFGCopier("SpecTE", "TE", this.specGenerationSourceDirectory, configContent);
        cfgCopier.copy();
        File outFile = new File(this.specGenerationSourceDirectory, "TE.out");
        TLCRunner tlcRunner = new TLCRunner(this.tlcArguments, outFile);
        System.out.println("Forking TLC...");
        int errorCode = tlcRunner.run();
        MCOutputParser.prettyPrintToStream((OutputStream)System.out, this.specGenerationSourceDirectory, "TE");
        return errorCode;
    }

    private boolean performPreFlightFileChecks() {
        String filename;
        File outputFile;
        boolean outputShouldExist;
        boolean specifiedModuleIsSpecTE = this.specGenerationOriginalSpecName.equals("SpecTE");
        boolean bl = outputShouldExist = !this.expectedOutputFromStdIn || specifiedModuleIsSpecTE && RunMode.TRACE_EXPLORATION.equals((Object)this.runMode);
        if (outputShouldExist && !(outputFile = new File(this.specGenerationSourceDirectory, filename = this.specGenerationOriginalSpecName + ".out")).exists()) {
            this.printErrorMessage("source directory (" + this.specGenerationSourceDirectory + ") does not contain " + filename);
            this.runMode = null;
            return false;
        }
        if (RunMode.GENERATE_SPEC_TE.equals((Object)this.runMode) || RunMode.TRACE_EXPLORATION.equals((Object)this.runMode)) {
            filename = this.specGenerationOriginalSpecName + ".tla";
            File tlaFile = new File(this.specGenerationSourceDirectory, filename);
            if (!tlaFile.exists()) {
                this.printErrorMessage("source directory (" + this.specGenerationSourceDirectory + ") does not contain " + filename);
                this.runMode = null;
                return false;
            }
            filename = this.specGenerationOriginalSpecName + ".cfg";
            File configFile = new File(this.specGenerationSourceDirectory, filename);
            if (!configFile.exists()) {
                this.printErrorMessage("source directory (" + this.specGenerationSourceDirectory + ") does not contain " + filename);
                this.runMode = null;
                return false;
            }
            if (!this.overwriteGeneratedFiles) {
                File teTLA;
                File specTETLA;
                if (!specifiedModuleIsSpecTE && (specTETLA = new File(this.specGenerationSourceDirectory, "SpecTE.tla")).exists()) {
                    this.printErrorMessage("specified source directory already contains " + specTETLA.getName() + "; specify '" + GENERATE_SPEC_OVERWRITE_PARAMETER_NAME + "' to overwrite.");
                    this.runMode = null;
                    return false;
                }
                if (RunMode.TRACE_EXPLORATION.equals((Object)this.runMode) && (teTLA = new File(this.specGenerationSourceDirectory, "TE.tla")).exists()) {
                    this.printErrorMessage("specified source directory already contains " + teTLA.getName() + "; specify '" + GENERATE_SPEC_OVERWRITE_PARAMETER_NAME + "' to overwrite.");
                    this.runMode = null;
                    return false;
                }
            }
        }
        return true;
    }

    private void writeSpecTEFiles(MCParserResults results, MCError error) throws IOException {
        TraceExplorer.writeSpecTEFiles(this.specGenerationSourceDirectory, this.specGenerationOriginalSpecName, results, error);
    }

    private void printErrorMessage(String message) {
        MP.printError(1000, message);
    }

    private static void printUsageAndExit() {
        ArrayList<List<UsageGenerator.Argument>> commandVariants = new ArrayList<List<UsageGenerator.Argument>>();
        UsageGenerator.Argument expressionFile = new UsageGenerator.Argument(EXPRESSIONS_FILE_PARAMETER_NAME, "file", "expressions specified, one per line if being used in conjunction\nwith -traceExpressions and just one if being used with -replBis\nthis file must be in the source directory or specified by\nfull path", false);
        UsageGenerator.Argument jvmArguments = new UsageGenerator.Argument(MODEL_CHECK_JVM_ARGUMENTS_PARAMETER_NAME, "\"-Xmx3072m -Xms512m\"", "these arguments will be passed on to the TLC JVM when performing\nthe model check", true);
        UsageGenerator.Argument overwrite = new UsageGenerator.Argument(GENERATE_SPEC_OVERWRITE_PARAMETER_NAME, "if specified, and if a SpecTE, or TE, file pair already exists,\nthey will be overwritten; if they exist, and this has not been\nspecified, the process will halt", true);
        UsageGenerator.Argument sourceDirectory = new UsageGenerator.Argument(SOURCE_DIR_PARAMETER_NAME, "path", "the path to the directory containing tool output from model\nchecking; defaults to CWD. This will be ignored if no SpecName\nhas been specified (and so tool output will be expected to\narrive on stdin)", true);
        UsageGenerator.Argument spec2 = new UsageGenerator.Argument("SpecName", "if no spec name is specified, tool output will be expected to arrive\nvia stdin and any -source definition will be ignored.", false);
        UsageGenerator.Argument tlcArguments = new UsageGenerator.Argument(MODEL_CHECK_TLC_ARGUMENTS_PARAMETER_NAME, "\"-some -other 2 -tlc arguments\"", "these arguments will be passed on to TLC when performing the\nmodel check; -config, -tool, and -metadir will be ignored,\nif specified", true);
        ArrayList<UsageGenerator.Argument> traceExpressionsVariant = new ArrayList<UsageGenerator.Argument>();
        traceExpressionsVariant.add(jvmArguments);
        traceExpressionsVariant.add(overwrite);
        traceExpressionsVariant.add(sourceDirectory);
        traceExpressionsVariant.add(tlcArguments);
        traceExpressionsVariant.add(spec2);
        traceExpressionsVariant.add(expressionFile);
        traceExpressionsVariant.add(new UsageGenerator.Argument(TRACE_EXPRESSIONS_FUNCTION_PARAMETER_NAME, "evaluate trace expressions in the context of an error state\nspecified through a generated SpecTE file; if the 'SpecName'\nspecified is anything other that 'SpecTE', the tool will\ngenerate the SpecTE file pair, prior to generating the TE\nfile pair for the subsequently performed model checking", false));
        commandVariants.add(traceExpressionsVariant);
        ArrayList<UsageGenerator.Argument> replBisVariant = new ArrayList<UsageGenerator.Argument>();
        replBisVariant.add(jvmArguments);
        replBisVariant.add(tlcArguments);
        replBisVariant.add(new UsageGenerator.Argument(QUASI_REPL_PARAMETER_NAME, "perform a one-off evaluation of an expression", false));
        replBisVariant.add(expressionFile);
        commandVariants.add(replBisVariant);
        ArrayList<UsageGenerator.Argument> generateSpecVariant = new ArrayList<UsageGenerator.Argument>();
        generateSpecVariant.add(overwrite);
        generateSpecVariant.add(sourceDirectory);
        generateSpecVariant.add(spec2);
        generateSpecVariant.add(new UsageGenerator.Argument(GENERATE_SPEC_FUNCTION_PARAMETER_NAME, "generate a SpecTE tla/cfg pair from a model checking tool mode\noutput", false));
        commandVariants.add(generateSpecVariant);
        ArrayList<UsageGenerator.Argument> prettyPrintVariant = new ArrayList<UsageGenerator.Argument>();
        prettyPrintVariant.add(sourceDirectory);
        prettyPrintVariant.add(spec2);
        prettyPrintVariant.add(new UsageGenerator.Argument(PRETTY_PRINT_FUNCTION_PARAMETER_NAME, "pretty print the error states of a model checking tool mode\noutput", false));
        commandVariants.add(prettyPrintVariant);
        UsageGenerator.displayUsage(ToolIO.out, "TraceExplorer", TLCGlobals.versionOfTLC, "a tool for working with TLC tool output and exploring trace expressions", Messages.getString("TraceExplorerDescription"), commandVariants, null, ' ');
        System.exit(-1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            TraceExplorer.printUsageAndExit();
        }
        try {
            TraceExplorer te = new TraceExplorer(args);
            int returnCode = te.execute();
            System.exit(returnCode);
        }
        catch (Exception e2) {
            System.err.println("Caught exception: " + e2.getLocalizedMessage());
            TraceExplorer.printUsageAndExit();
        }
    }

    static {
        TLC_ARGUMENTS_TO_IGNORE.put("-config", Boolean.TRUE);
        TLC_ARGUMENTS_TO_IGNORE.put("-metadir", Boolean.TRUE);
        TLC_ARGUMENTS_TO_IGNORE.put("-tool", Boolean.FALSE);
    }

    private static enum RunMode {
        GENERATE_SPEC_TE,
        PRETTY_PRINT,
        GENERATE_FROM_TLC_RUN,
        QUASI_REPL,
        TRACE_EXPLORATION;

    }
}

