/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import tlc2.output.AbstractTLACopier;

public class TLACopier
extends AbstractTLACopier {
    private final String initNextDefinitions;
    private final boolean needExtendTLC;
    private final boolean needExtendToolbox;

    public TLACopier(String originalName, String newName, File sourceLocation, String initNextDefinitionTLA, boolean originalExtendsTLC, boolean originalExtendsToolbox) {
        super(originalName, newName, sourceLocation);
        this.initNextDefinitions = initNextDefinitionTLA;
        this.needExtendTLC = !originalExtendsTLC;
        this.needExtendToolbox = !originalExtendsToolbox;
    }

    @Override
    protected void copyLine(BufferedWriter writer2, String originalLine, int lineNumber) throws IOException {
        if (!this.inBody) {
            String lineToWrite;
            Matcher m = this.modulePattern.matcher(originalLine);
            if (m.find()) {
                lineToWrite = m.group(1) + ' ' + this.newModuleName + ' ' + "----";
                this.inBody = true;
            } else {
                lineToWrite = originalLine;
            }
            writer2.write(lineToWrite + '\n');
        } else if (originalLine.trim().startsWith("EXTENDS")) {
            String line = originalLine;
            if (this.needExtendTLC) {
                line = line + ", TLC";
            }
            if (this.needExtendToolbox) {
                line = line + ", Toolbox";
            }
            writer2.write(line + '\n');
        } else {
            Matcher m = CLOSING_BODY_PATTERN.matcher(originalLine);
            if (m.matches()) {
                writer2.write(this.initNextDefinitions + '\n');
            }
            writer2.write(originalLine + '\n');
        }
    }
}

