/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import tlc2.output.MP;
import tlc2.tool.TLCState;
import tlc2.tool.queue.StateQueue;
import tlc2.util.StatePoolReader;
import tlc2.util.StatePoolWriter;
import tlc2.value.ValueInputStream;
import tlc2.value.ValueOutputStream;
import util.Assert;
import util.FileUtil;

public class DiskStateQueue
extends StateQueue {
    private static final int BufSize = Integer.getInteger(DiskStateQueue.class.getName() + ".BufSize", 8192);
    private final String filePrefix;
    protected TLCState[] deqBuf = new TLCState[BufSize];
    protected TLCState[] enqBuf = new TLCState[BufSize];
    protected int deqIndex = BufSize;
    protected int enqIndex = 0;
    protected StatePoolReader reader;
    protected StatePoolWriter writer;
    protected final StatePoolCleaner cleaner;
    private int loPool = 1;
    private int hiPool = 0;
    private int lastLoPool = 0;
    private int newLastLoPool;
    private File loFile;

    DiskStateQueue() throws IOException {
        this(Files.createTempDirectory("DiskStateQueue", new FileAttribute[0]).toFile().toString());
    }

    public DiskStateQueue(String diskdir) {
        this.filePrefix = diskdir + FileUtil.separator;
        File rFile = new File(this.filePrefix + Integer.toString(0));
        this.reader = new StatePoolReader(BufSize, rFile);
        this.reader.setDaemon(true);
        this.loFile = new File(this.filePrefix + Integer.toString(this.loPool));
        this.reader.start();
        this.writer = new StatePoolWriter(BufSize, this.reader);
        this.writer.setDaemon(true);
        this.writer.start();
        this.cleaner = new StatePoolCleaner();
        this.cleaner.setDaemon(true);
        this.cleaner.start();
    }

    @Override
    final void enqueueInner(TLCState state) {
        if (this.enqIndex == this.enqBuf.length) {
            try {
                String pstr = Integer.toString(this.hiPool);
                File file2 = new File(this.filePrefix + pstr);
                this.enqBuf = this.writer.doWork(this.enqBuf, file2);
                ++this.hiPool;
                this.enqIndex = 0;
            }
            catch (Exception e2) {
                Assert.fail(2175, new String[]{"queue", e2.getMessage() == null ? e2.toString() : e2.getMessage()});
            }
        }
        this.enqBuf[this.enqIndex++] = state;
    }

    @Override
    final TLCState dequeueInner() {
        if (this.deqIndex == this.deqBuf.length) {
            this.fillDeqBuffer();
        }
        return this.deqBuf[this.deqIndex++];
    }

    @Override
    TLCState peekInner() {
        if (this.deqIndex == this.deqBuf.length) {
            this.fillDeqBuffer();
        }
        return this.deqBuf[this.deqIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillDeqBuffer() {
        block10: {
            try {
                Object buf;
                if (this.loPool + 1 <= this.hiPool) {
                    if (this.loPool + 1 >= this.hiPool) {
                        this.writer.ensureWritten();
                    }
                    this.deqBuf = this.reader.doWork(this.deqBuf, this.loFile);
                    this.deqIndex = 0;
                    ++this.loPool;
                    String pstr = Integer.toString(this.loPool);
                    this.loFile = new File(this.filePrefix + pstr);
                } else {
                    this.writer.ensureWritten();
                    buf = this.reader.getCache(this.deqBuf, this.loFile);
                    if (buf != null) {
                        this.deqBuf = buf;
                        this.deqIndex = 0;
                        ++this.loPool;
                        String pstr = Integer.toString(this.loPool);
                        this.loFile = new File(this.filePrefix + pstr);
                    } else {
                        this.deqIndex = this.deqBuf.length - this.enqIndex;
                        System.arraycopy(this.enqBuf, 0, this.deqBuf, this.deqIndex, this.enqIndex);
                        this.enqIndex = 0;
                    }
                }
                if (this.loPool - this.lastLoPool <= 100) break block10;
                buf = this.cleaner;
                synchronized (buf) {
                    this.cleaner.deleteUpTo = this.loPool - 1;
                    this.cleaner.notifyAll();
                }
            }
            catch (Exception e2) {
                Assert.fail(2174, new String[]{"queue", e2.getMessage() == null ? e2.toString() : e2.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void beginChkpt() throws IOException {
        int i;
        StatePoolCleaner statePoolCleaner = this.cleaner;
        synchronized (statePoolCleaner) {
            this.cleaner.finished = true;
            this.cleaner.notifyAll();
        }
        String filename = this.filePrefix + "queue.tmp";
        ValueOutputStream vos = new ValueOutputStream(filename);
        vos.writeLongNat(this.len);
        vos.writeInt(this.loPool);
        vos.writeInt(this.hiPool);
        vos.writeInt(this.enqIndex);
        vos.writeInt(this.deqIndex);
        for (i = 0; i < this.enqIndex; ++i) {
            this.enqBuf[i].write(vos);
        }
        for (i = this.deqIndex; i < this.deqBuf.length; ++i) {
            this.deqBuf[i].write(vos);
        }
        vos.close();
        this.newLastLoPool = this.loPool - 1;
    }

    @Override
    public final void commitChkpt() throws IOException {
        for (int i = this.lastLoPool; i < this.newLastLoPool; ++i) {
            String pstr = Integer.toString(i);
            File oldPool = new File(this.filePrefix + pstr);
            if (oldPool.delete()) continue;
            String msg = "DiskStateQueue.commitChkpt: cannot delete " + oldPool;
            throw new IOException(msg);
        }
        this.lastLoPool = this.newLastLoPool;
        File oldChkpt = new File(this.filePrefix + "queue.chkpt");
        File newChkpt = new File(this.filePrefix + "queue.tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            String msg = "DiskStateQueue.commitChkpt: cannot delete " + oldChkpt;
            throw new IOException(msg);
        }
    }

    @Override
    public final void recover() throws IOException {
        int i;
        String filename = this.filePrefix + "queue.chkpt";
        ValueInputStream vis = new ValueInputStream(filename);
        this.len = vis.readInt();
        this.loPool = vis.readInt();
        this.hiPool = vis.readInt();
        this.enqIndex = vis.readInt();
        this.deqIndex = vis.readInt();
        this.lastLoPool = this.loPool - 1;
        for (i = 0; i < this.enqIndex; ++i) {
            this.enqBuf[i] = TLCState.Empty.createEmpty();
            this.enqBuf[i].read(vis);
        }
        for (i = this.deqIndex; i < this.deqBuf.length; ++i) {
            this.deqBuf[i] = TLCState.Empty.createEmpty();
            this.deqBuf[i].read(vis);
        }
        vis.close();
        File file2 = new File(this.filePrefix + Integer.toString(this.lastLoPool));
        boolean canRead = this.lastLoPool < this.hiPool;
        this.reader.restart(file2, canRead);
        String pstr = Integer.toString(this.loPool);
        this.loFile = new File(this.filePrefix + pstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAll() {
        super.finishAll();
        Thread thread2 = this.writer;
        synchronized (thread2) {
            this.writer.notifyAll();
        }
        thread2 = this.reader;
        synchronized (thread2) {
            this.reader.setFinished();
            this.reader.notifyAll();
        }
        thread2 = this.cleaner;
        synchronized (thread2) {
            this.cleaner.finished = true;
            this.cleaner.notifyAll();
        }
    }

    @Override
    public void delete() {
        this.finishAll();
        new File(this.filePrefix).delete();
    }

    private class StatePoolCleaner
    extends Thread {
        private volatile boolean finished;
        public int deleteUpTo;

        private StatePoolCleaner() {
            super("TLCStatePoolCleaner");
            this.finished = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StatePoolCleaner statePoolCleaner = this;
                synchronized (statePoolCleaner) {
                    while (!this.finished) {
                        this.wait();
                        if (this.finished) {
                            return;
                        }
                        for (int i = DiskStateQueue.this.lastLoPool; i < this.deleteUpTo; ++i) {
                            File oldPoolFile = new File(DiskStateQueue.this.filePrefix + Integer.toString(i));
                            if (oldPoolFile.delete()) continue;
                            MP.printWarning(2270, oldPoolFile.getCanonicalPath());
                        }
                        DiskStateQueue.this.lastLoPool = this.deleteUpTo;
                    }
                }
            }
            catch (Exception e2) {
                MP.printError(2270, e2.getMessage(), (Throwable)e2);
                System.exit(1);
            }
        }
    }
}

