/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcal.PcalParams;
import pcal.TLAtoPCalMapping;
import pcal.trans;
import util.ToolIO;

public class Translator {
    private String output;
    private final String input;

    public Translator(String anInput, String[] args) {
        this.input = anInput;
        ToolIO.reset();
        ToolIO.setMode(1);
        PcalParams.resetParams();
        PcalParams.tlaPcalMapping = new TLAtoPCalMapping();
        trans.parseAndProcessArguments(args);
    }

    public Translator(String anInput, List<String> args) {
        this(anInput, args.toArray(new String[args.size()]));
    }

    public boolean translate() {
        String[] lines = this.input.split("\\r?\\n");
        List<String> in = Arrays.asList(lines);
        List<String> out = trans.performTranslation(in);
        if (out != null) {
            StringBuilder buf = new StringBuilder();
            String lineSeparator = System.getProperty("line.separator");
            for (String line : out) {
                buf.append(line);
                buf.append(lineSeparator);
            }
            this.output = buf.toString();
        }
        return this.output != null && PcalParams.tlaPcalMapping != null;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean hasChanged() {
        return !this.input.equals(this.output);
    }

    public TLAtoPCalMapping getMapping() {
        return PcalParams.tlaPcalMapping;
    }

    public List<Error> getErrors() {
        String[] messages = ToolIO.getAllMessages();
        Vector<Error> errorMessages = new Vector<Error>();
        for (int i = 0; i < messages.length; ++i) {
            int position = messages[i].indexOf("\nUnrecoverable error:\n -- ");
            if (position == -1) continue;
            errorMessages.add(new Error(messages[i].substring(position, messages[i].length() - ".\n".length())));
        }
        return errorMessages;
    }

    public static class Error {
        private static final String LINE = "line ";
        private static final String COLUMN = ", column ";
        private final String error;

        public Error(String anError) {
            this.error = anError;
        }

        public String toString() {
            return this.error;
        }

        public int[] getLocation() {
            int lineStarts = this.error.indexOf(LINE);
            int lineEnds = this.error.indexOf(COLUMN);
            if (lineStarts != -1 && lineEnds != -1) {
                String line = this.error.substring(lineStarts + LINE.length(), lineEnds);
                String afterColumnString = this.error.substring(lineEnds + COLUMN.length());
                Matcher matcher = Pattern.compile("\\s*\\d+").matcher(afterColumnString);
                matcher.find();
                String column = matcher.group().trim();
                int lineNumber = -1;
                int columnNumber = -1;
                try {
                    lineNumber = Integer.parseInt(line);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    columnNumber = Integer.parseInt(column);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return new int[]{lineNumber, columnNumber, lineNumber, columnNumber + 1};
            }
            return new int[]{-1, -1, -1, -1};
        }
    }
}

