/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.util.Hashtable;
import tlc2.tool.EvalException;
import tlc2.util.Vect;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueVec;

public class TransitiveClosure
implements ValueConstants {
    public static final long serialVersionUID = 20160822L;

    public static Value Warshall(Value rel) {
        if (!(rel instanceof Enumerable)) {
            throw new EvalException(2176, new String[]{"TransitiveClosure", "an enumerable set", Values.ppr(rel.toString())});
        }
        int maxLen = 2 * rel.size();
        boolean[][] matrix = new boolean[maxLen][maxLen];
        ValueEnumeration elems = ((Enumerable)((Object)rel)).elements();
        Vect<Value> elemList = new Vect<Value>();
        Hashtable<Value, Integer> fps = new Hashtable<Value, Integer>();
        int cnt = 0;
        Value elem = null;
        while ((elem = elems.nextElement()) != null) {
            TupleValue tv = (TupleValue)elem.toTuple();
            if (tv == null || tv.size() != 2) {
                throw new EvalException(2157, Values.ppr(elem.toString()));
            }
            Value elem1 = tv.elems[0];
            Value elem2 = tv.elems[1];
            int num1 = cnt;
            Integer num2 = (Integer)fps.get(elem1);
            if (num2 == null) {
                fps.put(elem1, new Integer(cnt));
                elemList.addElement(elem1);
            } else {
                num1 = num2;
            }
            int num22 = ++cnt;
            num2 = (Integer)fps.get(elem2);
            if (num2 == null) {
                fps.put(elem2, new Integer(cnt));
                elemList.addElement(elem2);
                ++cnt;
            } else {
                num22 = num2;
            }
            matrix[num1][num22] = true;
        }
        for (int y = 0; y < cnt; ++y) {
            for (int x = 0; x < cnt; ++x) {
                if (!matrix[x][y]) continue;
                for (int z = 0; z < cnt; ++z) {
                    if (!matrix[y][z]) continue;
                    matrix[x][z] = true;
                }
            }
        }
        ValueVec newElems = new ValueVec();
        for (int i = 0; i < cnt; ++i) {
            for (int j = 0; j < cnt; ++j) {
                if (!matrix[i][j]) continue;
                Value elem1 = (Value)elemList.elementAt(i);
                Value elem2 = (Value)elemList.elementAt(j);
                TupleValue newElem = new TupleValue(elem1, elem2);
                newElems.addElement(newElem);
            }
        }
        return new SetEnumValue(newElems, false);
    }
}

