/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import tlc2.output.MP;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.util.BufferedRandomAccessFile;
import tlc2.util.LongVec;
import tlc2.util.statistics.IBucketStatistics;
import util.FileUtil;

public abstract class AbstractDiskGraph {
    public static final long MAX_PTR = 0x4000000000000000L;
    public static final long MAX_LINK = Long.MAX_VALUE;
    private final String chkptName;
    protected final String metadir;
    protected final BufferedRandomAccessFile nodeRAF;
    protected final BufferedRandomAccessFile nodePtrRAF;
    protected final LongVec initNodes;
    protected GraphNode[] gnodes;
    private final IBucketStatistics outDegreeGraphStats;
    private long sizeAtCheck = 1L;

    public static boolean isFilePointer(long loc) {
        return loc < 0x4000000000000000L;
    }

    public AbstractDiskGraph(String metadir, int soln, IBucketStatistics graphStats) throws IOException {
        this.metadir = metadir;
        this.outDegreeGraphStats = graphStats;
        this.chkptName = metadir + FileUtil.separator + "dgraph_" + soln;
        String fnameForNodes = metadir + FileUtil.separator + "nodes_" + soln;
        this.nodeRAF = new BufferedRandomAccessFile(fnameForNodes, "rw");
        String fnameForPtrs = metadir + FileUtil.separator + "ptrs_" + soln;
        this.nodePtrRAF = new BufferedRandomAccessFile(fnameForPtrs, "rw");
        this.initNodes = new LongVec(1);
        this.gnodes = null;
    }

    public final void addInitNode(long node2, int tidx) {
        this.initNodes.addElement(node2);
        this.initNodes.addElement(tidx);
    }

    public final LongVec getInitNodes() {
        return this.initNodes;
    }

    public final void createCache() {
        this.gnodes = new GraphNode[65536];
    }

    public final void destroyCache() {
        this.gnodes = null;
    }

    public final void close() throws IOException {
        this.nodeRAF.close();
        this.nodePtrRAF.close();
    }

    public final long addNode(GraphNode node2) throws IOException {
        this.outDegreeGraphStats.addSample(node2.succSize());
        long ptr = this.nodeRAF.getFilePointer();
        this.putNode(node2, ptr);
        this.nodePtrRAF.writeLong(node2.stateFP);
        this.nodePtrRAF.writeInt(node2.tindex);
        this.nodePtrRAF.writeLongNat(ptr);
        node2.write(this.nodeRAF);
        return ptr;
    }

    protected abstract boolean checkDuplicate(GraphNode var1);

    public abstract GraphNode getNode(long var1, int var3) throws IOException;

    protected boolean isInitState(GraphNode gnode) {
        int numOfInits = this.initNodes.size();
        for (int j = 0; j < numOfInits; j += 2) {
            long state = this.initNodes.elementAt(j);
            int tidx = (int)this.initNodes.elementAt(j + 1);
            if (gnode.stateFP != state || gnode.tindex != tidx) continue;
            return true;
        }
        return false;
    }

    protected abstract void putNode(GraphNode var1, long var2);

    public final GraphNode getNode(long stateFP, int tidx, long ptr) throws IOException {
        int idx = (int)(stateFP + (long)tidx) & 0xFFFF;
        GraphNode gnode = this.gnodes[idx];
        if (gnode != null && gnode.stateFP == stateFP && gnode.tindex == tidx) {
            return gnode;
        }
        GraphNode gnode1 = this.getNodeFromDisk(stateFP, tidx, ptr);
        if (gnode == null) {
            this.gnodes[idx] = gnode1;
        }
        return gnode1;
    }

    protected final GraphNode getNodeFromDisk(long stateFP, int tidx, long ptr) throws IOException {
        if (ptr < 0L) {
            throw new IllegalArgumentException("Invalid negative file pointer: " + ptr);
        }
        long curPtr = this.nodeRAF.getFilePointer();
        this.nodeRAF.seek(ptr);
        GraphNode gnode1 = new GraphNode(stateFP, tidx);
        gnode1.read(this.nodeRAF);
        this.nodeRAF.seek(curPtr);
        return gnode1;
    }

    public abstract long getPtr(long var1, int var3);

    public final void makeNodePtrTbl() throws IOException {
        long ptr = this.nodePtrRAF.getFilePointer();
        long len = this.nodePtrRAF.length();
        this.makeNodePtrTbl(len);
        this.nodePtrRAF.seek(ptr);
    }

    protected abstract void makeNodePtrTbl(long var1) throws IOException;

    public abstract long getLink(long var1, int var3);

    public abstract long putLink(long var1, int var3, long var4);

    public abstract void setMaxLink(long var1, int var3);

    public boolean checkInvariants(int slen, int alen) {
        Iterator<GraphNode> itr = this.iterator();
        while (itr.hasNext()) {
            GraphNode gn = itr.next();
            if (gn.checkInvariants(slen, alen)) continue;
            return false;
        }
        return true;
    }

    private Iterator<GraphNode> iterator() {
        try {
            this.nodePtrRAF.seek(0L);
            final long length = this.nodePtrRAF.length();
            return new Iterator<GraphNode>(){

                @Override
                public boolean hasNext() {
                    return AbstractDiskGraph.this.nodePtrRAF.getFilePointer() < length;
                }

                @Override
                public GraphNode next() {
                    try {
                        long fp = AbstractDiskGraph.this.nodePtrRAF.readLong();
                        int tidx = AbstractDiskGraph.this.nodePtrRAF.readInt();
                        long loc = AbstractDiskGraph.this.nodePtrRAF.readLongNat();
                        return AbstractDiskGraph.this.getNodeFromDisk(fp, tidx, loc);
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported!");
                }
            };
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    public LongVec getPath(long state, int tidx) throws IOException {
        throw new RuntimeException("Couldn't re-create liveness trace (path) starting at: " + state + " and tidx: " + tidx);
    }

    public abstract long size();

    public long getSizeOnDisk() throws IOException {
        return this.nodePtrRAF.length() + this.nodeRAF.length();
    }

    public long getSizeAtLastCheck() {
        return this.sizeAtCheck;
    }

    public void recordSize() {
        this.sizeAtCheck = this.size();
    }

    public abstract String toDotViz(OrderOfSolution var1);

    protected String toDotVizLegend(OrderOfSolution oos) {
        LiveExprNode[] checkState;
        StringBuffer sb = new StringBuffer();
        sb.append("subgraph cluster_legend {");
        sb.append("graph[style=bold];");
        sb.append("label = \"PossibleErrorModel\" style=\"solid\"\n");
        sb.append("node [ labeljust=\"l\",shape=record ]\n");
        int i = 1;
        for (LiveExprNode liveExprNode : checkState = oos.getCheckState()) {
            sb.append(String.format("S%s [label=\"S%s: %s\"]", i, i++, AbstractDiskGraph.node2dot(liveExprNode)));
            sb.append("\n");
        }
        i = 1;
        for (LiveExprNode liveExprNode : checkState = oos.getCheckAction()) {
            sb.append(String.format("A%s [label=\"A%s: %s\"]", i, i++, AbstractDiskGraph.node2dot(liveExprNode)));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    protected static String node2dot(LiveExprNode node2) {
        return node2.toString().replace("\\", "\\\\").replace("\"", "\\\"").replace("<", "\\<").replace(">", "\\>").trim().replace("\n", "\\l");
    }

    public final void writeDotViz(OrderOfSolution oos, File file2) {
        this.createCache();
        try {
            BufferedWriter bwr = new BufferedWriter(new FileWriter(file2));
            bwr.write(this.toDotViz(oos));
            bwr.flush();
            bwr.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.destroyCache();
    }

    public final synchronized void beginChkpt() throws IOException {
        this.nodeRAF.flush();
        this.nodePtrRAF.flush();
        FileOutputStream fos = new FileOutputStream(this.chkptName + ".chkpt.tmp");
        DataOutputStream dos = new DataOutputStream(fos);
        dos.writeLong(this.nodeRAF.getFilePointer());
        dos.writeLong(this.nodePtrRAF.getFilePointer());
        dos.close();
        fos.close();
    }

    public final void commitChkpt() throws IOException {
        File oldChkpt = new File(this.chkptName + ".chkpt");
        File newChkpt = new File(this.chkptName + ".chkpt.tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("DiskGraph.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    public final void recover() throws IOException {
        FileInputStream fis = new FileInputStream(this.chkptName + ".chkpt");
        DataInputStream dis = new DataInputStream(fis);
        long nodeRAFPos = dis.readLong();
        long nodePtrRAFPos = dis.readLong();
        dis.close();
        fis.close();
        this.makeNodePtrTbl(nodePtrRAFPos);
        this.nodeRAF.seek(nodeRAFPos);
        this.nodePtrRAF.seek(nodePtrRAFPos);
    }

    public abstract void reset() throws IOException;

    public void calculateOutDegreeDiskGraph(IBucketStatistics outDegreeGraphStats) throws IOException {
        try {
            this.nodePtrRAF.flush();
            this.nodeRAF.flush();
            this.nodePtrRAF.seek(0L);
            long len = this.nodePtrRAF.length();
            while (this.nodePtrRAF.getFilePointer() < len) {
                this.nodePtrRAF.seek(this.nodePtrRAF.getFilePointer() + 8L + 4L);
                long ptr = this.nodePtrRAF.readLongNat();
                this.nodeRAF.seek(ptr);
                int outArcCount = this.nodeRAF.readNat() / 3;
                outDegreeGraphStats.addSample(outArcCount);
            }
        }
        catch (IOException e2) {
            MP.printError(2129, e2);
            System.exit(1);
        }
    }

    public void calculateInDegreeDiskGraph(IBucketStatistics inDegreeGraphStats) throws IOException {
        HashMap<NodeRAFRecord, Integer> nodes2count = new HashMap<NodeRAFRecord, Integer>();
        try {
            this.nodeRAF.flush();
            this.nodeRAF.seek(0L);
            long len = this.nodeRAF.length();
            while (this.nodeRAF.getFilePointer() < len) {
                int cnt = this.nodeRAF.readNat() / 3;
                for (int i = 0; i < cnt; ++i) {
                    NodeRAFRecord record = new NodeRAFRecord();
                    record.read(this.nodeRAF);
                    Integer inArcCounter = (Integer)nodes2count.get(record);
                    if (inArcCounter == null) {
                        inArcCounter = new Integer(0);
                    }
                    nodes2count.put(record, inArcCounter + 1);
                }
                int checksLen = this.nodeRAF.readNat();
                this.nodeRAF.seek(this.nodeRAF.getFilePointer() + (long)(checksLen * 8));
            }
        }
        catch (IOException e2) {
            MP.printError(2129, e2);
            System.exit(1);
        }
        Collection values = nodes2count.values();
        for (Integer integer : values) {
            inDegreeGraphStats.addSample(integer);
        }
    }

    private class NodeRAFRecord {
        private long fp;
        private int tidx;

        private NodeRAFRecord() {
        }

        public void read(BufferedRandomAccessFile nodeRAF) throws IOException {
            long high = nodeRAF.readInt();
            long low = nodeRAF.readInt();
            this.fp = high << 32 | low & 0xFFFFFFFFL;
            this.tidx = nodeRAF.readInt();
        }

        public String toString() {
            return "NodeRAFRecord [fp=" + this.fp + ", tidx=" + this.tidx + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (int)(this.fp ^ this.fp >>> 32);
            result = 31 * result + this.tidx;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeRAFRecord other = (NodeRAFRecord)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.fp != other.fp) {
                return false;
            }
            return this.tidx == other.tidx;
        }

        private AbstractDiskGraph getOuterType() {
            return AbstractDiskGraph.this;
        }
    }
}

