/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.beans.Beans;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class CommandInfo {
    private final String commandName;
    private final String commandClass;

    public CommandInfo(String commandName, String commandClass) {
        this.commandName = commandName;
        this.commandClass = commandClass;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandClass() {
        return this.commandClass;
    }

    public Object getCommandObject(DataHandler dh, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object bean2 = Beans.instantiate(loader, this.commandClass);
        if (bean2 instanceof CommandObject) {
            ((CommandObject)bean2).setCommandContext(this.commandName, dh);
        } else if (bean2 instanceof Externalizable && dh != null) {
            ((Externalizable)bean2).readExternal(new ObjectInputStream(dh.getInputStream()));
        }
        return bean2;
    }
}

