/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

abstract class AbstractCopier {
    protected final String originalModuleName;
    protected final String newModuleName;
    protected final File sourceDirectory;
    protected File sourceFile;
    protected File destinationFile;

    AbstractCopier(String originalName, String newName, File sourceLocation) {
        this.originalModuleName = originalName;
        this.newModuleName = newName;
        this.sourceDirectory = sourceLocation;
    }

    protected abstract String getFileExtension();

    protected abstract void copyLine(BufferedWriter var1, String var2, int var3) throws IOException;

    protected void allInputHasBeenConsumed(BufferedWriter writer2) throws IOException {
    }

    protected void copyHasFinished() throws IOException {
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public final void copy() throws IOException {
        String extension = this.getFileExtension();
        this.sourceFile = new File(this.sourceDirectory, this.originalModuleName + extension);
        this.destinationFile = new File(this.sourceDirectory, this.newModuleName + extension);
        this.copy(new FileReader(this.sourceFile), new FileWriter(this.destinationFile));
    }

    protected void copy(Reader reader2, Writer writer2) throws IOException {
        try (BufferedReader br = new BufferedReader(reader2);
             BufferedWriter bw = new BufferedWriter(writer2);){
            String line;
            int lineCount = 1;
            while ((line = br.readLine()) != null) {
                this.copyLine(bw, line, lineCount);
                ++lineCount;
            }
            this.allInputHasBeenConsumed(bw);
        }
        this.copyHasFinished();
    }
}

