/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import tlc2.util.statistics.AbstractBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class ConcurrentBucketStatistics
extends AbstractBucketStatistics
implements IBucketStatistics {
    private final LongAdder observations = new LongAdder();
    private final ConcurrentNavigableMap<Integer, AtomicLong> buckets = new ConcurrentSkipListMap<Integer, AtomicLong>();

    ConcurrentBucketStatistics() {
        super("Concurrent Historgram");
    }

    public ConcurrentBucketStatistics(String aTitle) {
        super(aTitle);
    }

    public ConcurrentBucketStatistics(String aTitle, String pkg, String name2) {
        super(aTitle, pkg, name2);
    }

    @Override
    public void addSample(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Negative amount invalid");
        }
        AtomicLong atomicLong = (AtomicLong)this.buckets.get(amount);
        if (atomicLong == null) {
            this.buckets.putIfAbsent(amount, new AtomicLong(1L));
        } else {
            atomicLong.incrementAndGet();
        }
        this.observations.increment();
    }

    @Override
    public long getObservations() {
        return this.observations.sum();
    }

    @Override
    public NavigableMap<Integer, Long> getSamples() {
        TreeMap<Integer, Long> res2 = new TreeMap<Integer, Long>();
        for (Map.Entry entry : this.buckets.entrySet()) {
            res2.put((Integer)entry.getKey(), ((AtomicLong)entry.getValue()).get());
        }
        return res2;
    }
}

