/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import tlc2.tool.TLCState;
import tlc2.tool.queue.StateQueue;
import tlc2.value.ValueInputStream;
import tlc2.value.ValueOutputStream;
import util.Assert;
import util.FileUtil;

public final class MemStateQueue
extends StateQueue {
    private static final int InitialSize = 4096;
    private TLCState[] states = new TLCState[4096];
    private int start = 0;
    private String diskdir;

    MemStateQueue() throws IOException {
        this(Files.createTempDirectory("MemStateQueue", new FileAttribute[0]).toFile().toString());
    }

    public MemStateQueue(String metadir) {
        this.diskdir = metadir;
    }

    @Override
    final void enqueueInner(TLCState state) {
        if (this.len > Integer.MAX_VALUE) {
            Assert.fail(2175, new String[]{"queue", "Amount of states exceeds internal storage"});
        }
        if (this.len == (long)this.states.length) {
            TLCState[] newStates = new TLCState[this.getNewLength(this.len)];
            int copyLen = this.states.length - this.start;
            System.arraycopy(this.states, this.start, newStates, 0, copyLen);
            System.arraycopy(this.states, 0, newStates, copyLen, this.start);
            this.states = newStates;
            this.start = 0;
        }
        int last = (this.start + (int)this.len) % this.states.length;
        this.states[last] = state;
    }

    private int getNewLength(long oldLength) {
        return (int)Math.max(1L, oldLength * 4L / 3L + 1L);
    }

    @Override
    final TLCState dequeueInner() {
        TLCState res2 = this.states[this.start];
        this.states[this.start] = null;
        this.start = (this.start + 1) % this.states.length;
        return res2;
    }

    @Override
    final TLCState peekInner() {
        return this.states[this.start];
    }

    @Override
    public final void beginChkpt() throws IOException {
        String filename = this.diskdir + FileUtil.separator + "queue.tmp";
        ValueOutputStream vos = new ValueOutputStream(filename);
        vos.writeInt((int)this.len);
        int index2 = this.start;
        int i = 0;
        while ((long)i < this.len) {
            this.states[index2++].write(vos);
            if (index2 == this.states.length) {
                index2 = 0;
            }
            ++i;
        }
        vos.close();
    }

    @Override
    public final void commitChkpt() throws IOException {
        String oldName = this.diskdir + FileUtil.separator + "queue.chkpt";
        File oldChkpt = new File(oldName);
        String newName = this.diskdir + FileUtil.separator + "queue.tmp";
        File newChkpt = new File(newName);
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemStateQueue.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    @Override
    public final void recover() throws IOException {
        String filename = this.diskdir + FileUtil.separator + "queue.chkpt";
        ValueInputStream vis = new ValueInputStream(filename);
        this.len = vis.readInt();
        int i = 0;
        while ((long)i < this.len) {
            this.states[i] = TLCState.Empty.createEmpty();
            this.states[i].read(vis);
            ++i;
        }
        vis.close();
    }
}

