/*
 * Decompiled with CFR 0.152.
 */
package util;

public class StringHelper {
    public static String PLATFORM_NEWLINE = System.getProperty("line.separator");

    public static final String copyString(String str2, int copies) {
        String result = "";
        String powerOf2Copies = str2;
        int remaining = copies;
        while (remaining > 0) {
            if (remaining % 2 != 0) {
                result = result + powerOf2Copies;
            }
            if ((remaining /= 2) == 0) continue;
            powerOf2Copies = powerOf2Copies + powerOf2Copies;
        }
        return result;
    }

    public static final boolean onlySpaces(String str2) {
        return str2.trim().equals("");
    }

    public static final String trimFront(String str2) {
        int position;
        for (position = 0; position < str2.length() && Character.isWhitespace(str2.charAt(position)); ++position) {
        }
        return str2.substring(position, str2.length());
    }

    public static final String trimEnd(String str2) {
        int position;
        for (position = str2.length(); position > 0 && Character.isWhitespace(str2.charAt(position - 1)); --position) {
        }
        return str2.substring(0, position);
    }

    public static final int leadingSpaces(String str2) {
        return str2.length() - StringHelper.trimFront(str2).length();
    }

    public static final void printArray(Object[] array2) {
        if (array2 == null) {
            System.out.println("null array");
            return;
        }
        if (array2.length == 0) {
            System.out.println("zero-length array");
            return;
        }
        System.out.println("0-" + array2[0].toString() + "-0");
        for (int i = 1; i < array2.length; ++i) {
            System.out.println("*-" + array2[i].toString() + "-*");
        }
    }

    public static final String[] getWords(String str2) {
        String[] result = StringHelper.trimFront(str2).split("\\s+");
        return result;
    }

    public static final boolean isIdentifier(String str2) {
        boolean result = true;
        boolean allChars = true;
        for (int i = 0; result && i < str2.length(); ++i) {
            char ch = str2.charAt(i);
            result = Character.isLetterOrDigit(ch) || ch == '_';
            allChars = allChars && Character.isDigit(ch);
        }
        return result && !allChars;
    }
}

