/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;

public abstract class ObjectStack {
    protected int len = 0;

    public final void push(Object state) {
        this.enqueueInner(state);
        ++this.len;
    }

    public final Object pop() {
        if (this.len == 0) {
            return null;
        }
        Object state = this.dequeueInner();
        --this.len;
        return state;
    }

    public final synchronized void spush(Object state) {
        this.enqueueInner(state);
        ++this.len;
    }

    public final synchronized void spush(Object[] states) {
        for (int i = 0; i < states.length; ++i) {
            this.enqueueInner(states[i]);
        }
        this.len += states.length;
    }

    public final synchronized Object spop() {
        Object state = this.dequeueInner();
        --this.len;
        return state;
    }

    public final synchronized Object[] spop(int cnt) {
        int idx;
        Object[] states = new Object[cnt];
        for (idx = 0; idx < cnt && this.len > 0; ++idx) {
            states[idx] = this.dequeueInner();
            --this.len;
        }
        if (idx == cnt) {
            return states;
        }
        Object[] res2 = new Object[idx];
        for (int i = 0; i < idx; ++i) {
            res2[i] = states[i];
        }
        return res2;
    }

    public final int size() {
        return this.len;
    }

    abstract void enqueueInner(Object var1);

    abstract Object dequeueInner();

    public abstract void beginChkpt() throws IOException;

    public abstract void commitChkpt() throws IOException;

    public abstract void recover() throws IOException;
}

