/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import tlc2.module.Naturals;
import tlc2.tool.EvalException;
import tlc2.tool.impl.TLARegistry;
import tlc2.value.IBoolValue;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.UserObj;
import tlc2.value.impl.UserValue;
import tlc2.value.impl.Value;

public class Integers
extends UserObj
implements ValueConstants {
    public static final long serialVersionUID = 20160822L;
    private static final Value SetInt;

    public static Value Int() {
        return SetInt;
    }

    public static Value Nat() {
        return Naturals.Nat();
    }

    public static IntValue Plus(IntValue x, IntValue y) {
        return Naturals.Plus(x, y);
    }

    public static IntValue Minus(IntValue x, IntValue y) {
        return Naturals.Minus(x, y);
    }

    public static IntValue Times(IntValue x, IntValue y) {
        return Naturals.Times(x, y);
    }

    public static IBoolValue LT(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", "<", "integer", Values.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", "<", "integer", Values.ppr(y.toString())});
        }
        return ((IntValue)x).val < ((IntValue)y).val ? BoolValue.ValTrue : BoolValue.ValFalse;
    }

    public static IBoolValue LE(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", "<=", "integer", Values.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", "<=", "integer", Values.ppr(y.toString())});
        }
        return ((IntValue)x).val <= ((IntValue)y).val ? BoolValue.ValTrue : BoolValue.ValFalse;
    }

    public static BoolValue GT(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", ">", "integer", Values.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", ">", "integer", Values.ppr(y.toString())});
        }
        return ((IntValue)x).val > ((IntValue)y).val ? BoolValue.ValTrue : BoolValue.ValFalse;
    }

    public static IBoolValue GEQ(Value x, Value y) {
        if (!(x instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"first", ">=", "integer", Values.ppr(x.toString())});
        }
        if (!(y instanceof IntValue)) {
            throw new EvalException(2266, new String[]{"second", ">=", "integer", Values.ppr(y.toString())});
        }
        return ((IntValue)x).val >= ((IntValue)y).val ? BoolValue.ValTrue : BoolValue.ValFalse;
    }

    public static IntervalValue DotDot(IntValue x, IntValue y) {
        return new IntervalValue(x.val, y.val);
    }

    public static IntValue Neg(IntValue x) {
        int n = x.val;
        if (n == Integer.MIN_VALUE) {
            throw new EvalException(2178, "--2147483648");
        }
        return IntValue.gen(0 - n);
    }

    public static IntValue Divide(IntValue x, IntValue y) {
        if (y.val == 0) {
            throw new EvalException(2179);
        }
        if (x.val == Integer.MIN_VALUE && y.val == -1) {
            throw new EvalException(2178, "-2147483648 \\div -1");
        }
        int n1 = x.val;
        int n2 = y.val;
        int q = n1 / n2;
        if ((n1 < 0 && n2 > 0 || n1 > 0 && n2 < 0) && q * y.val != x.val) {
            --q;
        }
        return IntValue.gen(q);
    }

    public static IntValue Mod(IntValue x, IntValue y) {
        if (y.val <= 0) {
            throw new EvalException(2169, new String[]{"second", "%", "positive number", y.toString()});
        }
        int r = x.val % y.val;
        return IntValue.gen(r < 0 ? r + y.val : r);
    }

    public static IntValue Expt(IntValue x, IntValue y) {
        if (y.val < 0) {
            throw new EvalException(2169, new String[]{"second", "^", "natural number", y.toString()});
        }
        if (y.val == 0) {
            if (x.val == 0) {
                throw new EvalException(2180);
            }
            return IntValue.ValOne;
        }
        long res2 = x.val;
        for (int i = 1; i < y.val; ++i) {
            if ((res2 *= (long)x.val) >= Integer.MIN_VALUE && res2 <= Integer.MAX_VALUE) continue;
            throw new EvalException(2178, x.val + "^" + y.val);
        }
        return IntValue.gen((int)res2);
    }

    @Override
    public final int compareTo(Value val2) {
        if (val2 instanceof UserValue) {
            if (((UserValue)val2).userObj instanceof Integers) {
                return 0;
            }
            if (((UserValue)val2).userObj instanceof Naturals) {
                return 1;
            }
        }
        if (val2 instanceof ModelValue) {
            return 1;
        }
        throw new EvalException(2155, new String[]{"Int", Values.ppr(val2.toString())});
    }

    @Override
    public final boolean member(Value val2) {
        if (val2 instanceof IntValue) {
            return true;
        }
        if (val2 instanceof ModelValue) {
            return ((ModelValue)val2).modelValueMember(this);
        }
        throw new EvalException(2158, new String[]{Values.ppr(val2.toString()), "Int"});
    }

    @Override
    public final boolean isFinite() {
        return false;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        return sb.append("Int");
    }

    static {
        TLARegistry.put("Plus", "+");
        TLARegistry.put("Minus", "-");
        TLARegistry.put("Times", "*");
        TLARegistry.put("LT", "<");
        TLARegistry.put("LE", "\\leq");
        TLARegistry.put("GT", ">");
        TLARegistry.put("GEQ", "\\geq");
        TLARegistry.put("DotDot", "..");
        TLARegistry.put("Neg", "-.");
        TLARegistry.put("Divide", "\\div");
        TLARegistry.put("Mod", "%");
        TLARegistry.put("Expt", "^");
        SetInt = new UserValue(new Integers());
    }
}

