/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.util.Context;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import util.UniqueString;
import util.WrongInvocationException;

public final class TLAPlusExecutorState
extends TLCState {
    private Callable<?> callable;
    private IValue[] values;
    private static ITool mytool = null;
    private static SemanticNode viewMap = null;
    private static IMVPerm[] perms = null;

    @Override
    public Object execCallable() throws Exception {
        if (this.callable != null) {
            return this.callable.call();
        }
        return null;
    }

    @Override
    public void setCallable(Callable<?> f) {
        this.callable = f;
    }

    public static void setVariables(OpDeclNode[] variables) {
        vars = variables;
        Empty = new TLAPlusExecutorState(new IValue[vars.length]);
    }

    @Override
    public TLCState createEmpty() {
        return new TLAPlusExecutorState(new IValue[vars.length]);
    }

    protected TLAPlusExecutorState(IValue[] vals2) {
        this.values = vals2;
    }

    public static void setTool(ITool tool) {
        mytool = tool;
        viewMap = tool.getViewSpec();
        perms = tool.getSymmetryPerms();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TLAPlusExecutorState) {
            TLAPlusExecutorState state = (TLAPlusExecutorState)obj;
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] == null ? state.values[i] != null : state.values[i] == null || !this.values[i].equals(state.values[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final TLCState bind(UniqueString name2, IValue value) {
        int loc = name2.getVarLoc();
        this.values[loc] = value;
        return this;
    }

    @Override
    public final TLCState bind(SymbolNode id, IValue value) {
        throw new WrongInvocationException("SharedTLCState.bind: This is a TLC bug.");
    }

    @Override
    public final TLCState unbind(UniqueString name2) {
        int loc = name2.getVarLoc();
        this.values[loc] = null;
        return this;
    }

    @Override
    public final IValue lookup(UniqueString var) {
        int loc = var.getVarLoc();
        if (loc < 0) {
            return null;
        }
        return this.values[loc];
    }

    @Override
    public final boolean containsKey(UniqueString var) {
        return this.lookup(var) != null;
    }

    @Override
    public final TLCState copy() {
        int len = this.values.length;
        IValue[] vals2 = new IValue[len];
        for (int i = 0; i < len; ++i) {
            vals2[i] = this.values[i];
        }
        return new TLAPlusExecutorState(vals2);
    }

    @Override
    public final TLCState deepCopy() {
        int len = this.values.length;
        IValue[] vals2 = new IValue[len];
        for (int i = 0; i < len; ++i) {
            IValue val2 = this.values[i];
            if (val2 == null) continue;
            vals2[i] = val2.deepCopy();
        }
        return new TLAPlusExecutorState(vals2);
    }

    @Override
    public final StateVec addToVec(StateVec states) {
        return states.addElement(this.copy());
    }

    @Override
    public final void deepNormalize() {
        for (int i = 0; i < this.values.length; ++i) {
            IValue val2 = this.values[i];
            if (val2 == null) continue;
            val2.deepNormalize();
        }
    }

    @Override
    public final long fingerPrint() {
        int i;
        int sz = this.values.length;
        IValue[] minVals = this.values;
        if (perms != null) {
            IValue[] vals2 = new IValue[sz];
            block0: for (int i2 = 0; i2 < perms.length; ++i2) {
                int cmp = 0;
                for (int j = 0; j < sz; ++j) {
                    vals2[j] = this.values[j].permute(perms[i2]);
                    if (cmp == 0 && (cmp = vals2[j].compareTo(minVals[j])) > 0) continue block0;
                }
                if (cmp >= 0) continue;
                if (minVals == this.values) {
                    minVals = vals2;
                    vals2 = new IValue[sz];
                    continue;
                }
                IValue[] temp = minVals;
                minVals = vals2;
                vals2 = temp;
            }
        }
        long fp = FP64.New();
        if (viewMap == null) {
            for (i = 0; i < sz; ++i) {
                fp = minVals[i].fingerPrint(fp);
            }
            if (this.values != minVals) {
                for (i = 0; i < sz; ++i) {
                    this.values[i].deepNormalize();
                }
            }
        } else {
            for (i = 0; i < sz; ++i) {
                this.values[i].deepNormalize();
            }
            TLAPlusExecutorState state = this;
            if (minVals != this.values) {
                state = new TLAPlusExecutorState(minVals);
            }
            IValue val2 = mytool.eval(viewMap, Context.Empty, state);
            fp = val2.fingerPrint(fp);
        }
        return fp;
    }

    @Override
    public final boolean allAssigned() {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Set<OpDeclNode> getUnassigned() {
        TreeSet<OpDeclNode> unassignedVars = new TreeSet<OpDeclNode>(new Comparator<OpDeclNode>(){

            @Override
            public int compare(OpDeclNode o1, OpDeclNode o2) {
                return o1.getName().toString().compareTo(o2.getName().toString());
            }
        });
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            unassignedVars.add(vars[i]);
        }
        return unassignedVars;
    }

    @Override
    public final void read(IValueInputStream vis) throws IOException {
        super.read(vis);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = vis.read();
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        super.write(vos);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i].write(vos);
        }
    }

    @Override
    public final String toString() {
        if (TLCGlobals.useView && viewMap != null) {
            IValue val2 = mytool.eval(viewMap, Context.Empty, this);
            return viewMap.toString(val2);
        }
        StringBuffer result = new StringBuffer();
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key2 = vars[0].getName();
            IValue val3 = this.lookup(key2);
            result.append(key2.toString());
            result.append(" = ");
            result.append(Values.ppr(val3));
            result.append("\n");
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key3 = vars[i].getName();
                IValue val4 = this.lookup(key3);
                result.append("/\\ ");
                result.append(key3.toString());
                result.append(" = ");
                result.append(Values.ppr(val4));
                result.append("\n");
            }
        }
        return result.toString();
    }

    @Override
    public final String toString(TLCState lastState) {
        StringBuffer result = new StringBuffer();
        TLAPlusExecutorState lstate = (TLAPlusExecutorState)lastState;
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key2 = vars[0].getName();
            IValue val2 = this.lookup(key2);
            IValue lstateVal = lstate.lookup(key2);
            if (!lstateVal.equals(val2)) {
                result.append(key2.toString());
                result.append(" = " + Values.ppr(val2) + "\n");
            }
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key3 = vars[i].getName();
                IValue val3 = this.lookup(key3);
                IValue lstateVal = lstate.lookup(key3);
                if (lstateVal.equals(val3)) continue;
                result.append("/\\ ");
                result.append(key3.toString());
                result.append(" = " + Values.ppr(val3) + "\n");
            }
        }
        return result.toString();
    }
}

