/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.management;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import tlc2.tool.distributed.management.TLCStatisticsMXBean;

public class StateMonitor {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void main(String[] args) throws IOException, MalformedObjectNameException, InterruptedException, AttachNotSupportedException {
        int interval = 10;
        if (args.length == 1) {
            interval = Integer.valueOf(args[0]);
        }
        JMXServiceURL url = null;
        try {
            List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
            vmds.sort(new Comparator<VirtualMachineDescriptor>(){

                @Override
                public int compare(VirtualMachineDescriptor o1, VirtualMachineDescriptor o2) {
                    boolean c2;
                    boolean c1 = o1.displayName().contains("TLC");
                    if (c1 ^ (c2 = o2.displayName().contains("TLC"))) {
                        if (c1) {
                            return -1;
                        }
                        return 1;
                    }
                    return 0;
                }
            });
            int index2 = 1;
            try (Scanner scanner = new Scanner(System.in);){
                while (true) {
                    index2 = 1;
                    System.out.printf("============\n", new Object[0]);
                    for (VirtualMachineDescriptor vmd : vmds) {
                        System.out.printf("[%s]: pid=%s, name=%s\n", index2++, vmd.id(), vmd.displayName());
                    }
                    System.out.printf("Please select the number of the Java VM running TLC to connect to:\n", new Object[0]);
                    if (scanner.hasNextInt() && (index2 = scanner.nextInt()) >= 1 && index2 <= vmds.size()) {
                        break;
                    }
                    System.err.printf("Invalid selection %s\n", index2);
                }
            }
            VirtualMachineDescriptor tlcVMD = vmds.get(index2 - 1);
            VirtualMachine vm = tlcVMD.provider().attachVirtualMachine(tlcVMD);
            String address = vm.startLocalManagementAgent();
            url = new JMXServiceURL(address);
            System.out.printf("Connecting to TLC running at %s.\n(Hit Ctrl+c to terminate)\n", url);
        }
        catch (NumberFormatException nfe) {
            url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + args[0] + "/jmxrmi");
            System.out.printf("Connecting to TLC running at %s.\n(Hit Ctrl+c to terminate)\n", url);
        }
        JMXConnector jmxConnector = JMXConnectorFactory.connect(url);
        MBeanServerConnection mbeanServerConnection = jmxConnector.getMBeanServerConnection();
        ObjectName mbeanName = new ObjectName("tlc2.tool:type=ModelChecker");
        TLCStatisticsMXBean mbeanProxy = MBeanServerInvocationHandler.newProxyInstance(mbeanServerConnection, mbeanName, TLCStatisticsMXBean.class, true);
        while (true) {
            System.out.printf("############ %s ############\n%s", SDF.format(new Date()), mbeanProxy.getCurrentState());
            Thread.sleep((long)interval * 1000L);
        }
    }
}

