/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.util.regex.Pattern;

public interface FilenameToStream {
    public static final String TMPDIR = System.getProperty("java.io.tmpdir");

    public File resolve(String var1, boolean var2);

    public String getFullPath();

    public boolean isStandardModule(String var1);

    default public boolean isLibraryModule(String moduleName) {
        return this.isStandardModule(moduleName);
    }

    public static boolean isInJar(String aString) {
        return aString.startsWith("jar:") || aString.endsWith(".jar");
    }

    public static boolean isArchive(String aString) {
        return FilenameToStream.isInJar(aString) || aString.endsWith(".zip");
    }

    public static class TLAFile
    extends File {
        private static final String ROOT_PATH_REGEX = "^([a-zA-Z]+:)?" + (File.separatorChar == '\\' ? "\\\\" : File.separator);
        private static final Pattern ROOT_PATH_PATTERN = Pattern.compile(ROOT_PATH_REGEX);
        private final boolean isLibraryModule;
        private final transient FilenameToStream resolver;

        public TLAFile(String pathname, FilenameToStream fts) {
            this(pathname, false, fts);
        }

        public TLAFile(String pathname, boolean isLibraryModule, FilenameToStream fts) {
            super(pathname);
            this.isLibraryModule = isLibraryModule;
            this.resolver = fts;
        }

        public TLAFile(String parent, String child, FilenameToStream fts) {
            super(parent, ROOT_PATH_PATTERN.matcher(parent).find() && child.startsWith(parent) ? child.substring(parent.length()) : child);
            this.isLibraryModule = false;
            this.resolver = fts;
        }

        public boolean isLibraryModule() {
            return this.isLibraryModule;
        }

        public File getModuleOverride() {
            File moduleOverride = this.resolver.resolve(this.getName().replaceAll(".tla$", ".class"), false);
            if (moduleOverride.exists()) {
                return moduleOverride;
            }
            return null;
        }
    }
}

