/*
 * Decompiled with CFR 0.152.
 */
package tlc2.pprint;

import tlc2.pprint.FormatException;
import tlc2.pprint.Node;

public class Format {
    private static final String setOpen = "{ ";
    private static final String setClose = " }";
    private static final String setPad = "  ";
    private static final String setSep = ",";
    private static final String seqOpen = "<< ";
    private static final String seqClose = " >>";
    private static final String seqPad = "   ";
    private static final String seqSep = ",";
    private static final String funOpen = "( ";
    private static final String funClose = " )";
    private static final String funPad = "  ";
    private static final String funSep = " @@";
    private static final String funDiv = " :>";
    private static final String funDivPad = "    ";
    private static final String recOpen = "[ ";
    private static final String recClose = " ]";
    private static final String recPad = "  ";
    private static final String recSep = ",";
    private static final String recDiv = " |->";
    private static final String recDivPad = "    ";
    private static final String subsetOpen = "SUBSET ";
    private static final String subsetClose = " ";
    private static final String subsetPad = " ";
    private static final String subsetSep = ",";

    public static String format(Node value, int columnwidth, int trailerwidth, String leftpad) throws FormatException {
        if (value.length() <= columnwidth - trailerwidth) {
            return value.value();
        }
        switch (value.type()) {
            case 1: {
                return value.value();
            }
            case 2: {
                return Format.formatSimpleValue(value, columnwidth, trailerwidth, leftpad, setOpen, setClose, "  ", ",");
            }
            case 3: {
                return Format.formatSimpleValue(value, columnwidth, trailerwidth, leftpad, seqOpen, seqClose, seqPad, ",");
            }
            case 6: {
                return Format.formatPairValue(value, columnwidth, trailerwidth, leftpad, funOpen, funClose, "  ", funSep, funDiv, "    ");
            }
            case 4: {
                return Format.formatPairValue(value, columnwidth, trailerwidth, leftpad, recOpen, recClose, "  ", ",", recDiv, "    ");
            }
            case 8: {
                return Format.formatSimpleValue(value, columnwidth, trailerwidth, leftpad, subsetOpen, " ", " ", ",");
            }
        }
        throw new FormatException("TLC Bug: while formating output, the formatter called with an expression of type " + value.type() + " while formatting " + value.value() + " and this should never happen");
    }

    private static String formatSimpleValue(Node list, int columnwidth, int trailerwidth, String leftpad, String open, String close, String pad, String sep) throws FormatException {
        return open + Format.formatValues(list.children(), columnwidth - Math.max(open.length(), pad.length()), trailerwidth + close.length(), leftpad + pad, sep) + close;
    }

    private static String formatValues(Node values, int columnwidth, int trailerwidth, String leftpad, String sep) throws FormatException {
        String pp2 = "";
        for (Node value = values; value != null; value = value.next()) {
            pp2 = value.next() != null ? pp2 + Format.format(value, columnwidth, sep.length(), leftpad) + sep + "\n" + leftpad : pp2 + Format.format(value, columnwidth, trailerwidth, leftpad);
        }
        return pp2;
    }

    private static String formatPairValue(Node list, int columnwidth, int trailerwidth, String leftpad, String open, String close, String pad, String sep, String div, String divpad) throws FormatException {
        return open + Format.formatPairs(list.children(), columnwidth - Math.max(open.length(), pad.length()), trailerwidth + close.length(), leftpad + pad, sep, div, divpad) + close;
    }

    private static String formatPairs(Node pairs, int columnwidth, int trailerwidth, String leftpad, String sep, String div, String divpad) throws FormatException {
        String pp2 = "";
        for (Node pair2 = pairs; pair2 != null; pair2 = pair2.next()) {
            Node arg = pair2.children();
            Node val2 = arg.next();
            if (pair2.next() != null) {
                if (arg.length() + div.length() + 1 + val2.length() + sep.length() <= columnwidth) {
                    pp2 = pp2 + arg.value() + div + " " + val2.value() + sep + "\n" + leftpad;
                    continue;
                }
                if (arg.length() + div.length() <= columnwidth) {
                    pp2 = pp2 + arg.value() + div + "\n" + leftpad + divpad + Format.format(val2, columnwidth - divpad.length(), sep.length(), leftpad + divpad) + sep + "\n" + leftpad;
                    continue;
                }
                pp2 = pp2 + Format.format(arg, columnwidth, trailerwidth + div.length(), leftpad) + div + "\n" + leftpad + divpad + Format.format(val2, columnwidth - divpad.length(), sep.length(), leftpad + divpad) + sep + "\n" + leftpad;
                continue;
            }
            pp2 = arg.length() + div.length() + 1 + val2.length() <= columnwidth - trailerwidth ? pp2 + arg.value() + div + " " + val2.value() : (arg.length() + div.length() <= columnwidth ? pp2 + arg.value() + div + "\n" + leftpad + divpad + Format.format(val2, columnwidth - divpad.length(), trailerwidth, leftpad + divpad) : pp2 + Format.format(arg, columnwidth, trailerwidth + div.length(), leftpad) + div + "\n" + leftpad + divpad + Format.format(val2, columnwidth - divpad.length(), trailerwidth, leftpad + divpad));
        }
        return pp2;
    }
}

