/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.FolderClosedIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.FolderClosedException;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class MimePartDataSource
implements DataSource,
MessageAware {
    protected MimePart part;
    private MessageContext context;

    public MimePartDataSource(MimePart part) {
        this.part = part;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            InputStream is2;
            if (this.part instanceof MimeBodyPart) {
                is2 = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                is2 = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String encoding2 = MimeBodyPart.restrictEncoding(this.part, this.part.getEncoding());
            if (encoding2 != null) {
                return MimeUtility.decode(is2, encoding2);
            }
            return is2;
        }
        catch (FolderClosedException fex) {
            throw new FolderClosedIOException(fex.getFolder(), fex.getMessage());
        }
        catch (MessagingException mex) {
            IOException ioex = new IOException(mex.getMessage());
            ioex.initCause(mex);
            throw ioex;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("Writing not supported");
    }

    @Override
    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException mex) {
            return "application/octet-stream";
        }
    }

    @Override
    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public synchronized MessageContext getMessageContext() {
        if (this.context == null) {
            this.context = new MessageContext(this.part);
        }
        return this.context;
    }
}

