/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.math.BigInteger;
import tlc2.util.BigInt;
import util.Assert;

public class Combinatorics {
    public static final int MAXCHOOSENUM = 62;
    public static final int CHOOSETABLESIZE = 1770;
    public static long[] CHOOSETABLE = new long[1770];
    private static long[] SUMCHOOSETABLE = new long[1770];

    public static long choose(int n, int m) {
        if (n < 0 || m < 0) {
            Assert.check(m >= 0 && n >= 0 && n >= m, 2164, "choose");
        }
        if (m == 0 || m == n) {
            return 1L;
        }
        if (m == 1 || m == n - 1) {
            return n;
        }
        if (n == 0 || m > n) {
            return 0L;
        }
        int j = Combinatorics.choosePairToInt(n, m);
        if (j < 1770) {
            return CHOOSETABLE[j];
        }
        return Combinatorics.binomial(n, m);
    }

    public static long sumChoose(int n, int m) {
        Assert.check(m >= 0 && n >= 0 && n >= m, 2164, "sumChoose");
        if (m == 0) {
            return 1L;
        }
        if (m == n) {
            return 1L << n;
        }
        if (m == 1) {
            return n;
        }
        if (m == n - 1) {
            return (2L << n) - (long)n;
        }
        int j = Combinatorics.choosePairToInt(n, m);
        if (j < 1770) {
            return SUMCHOOSETABLE[j];
        }
        Assert.fail(2165, String.valueOf(62));
        return Long.MIN_VALUE;
    }

    public static int choosePairToInt(int n, int m) {
        return (n - 3) * (n - 4) / 2 + m - 2;
    }

    public static BigInteger toNum(BigInteger[] B, BigInteger[] N, int len) {
        Assert.check(B.length >= len && len > 0, 2134);
        BigInteger num2 = N[len - 1];
        for (int i = len - 2; i >= 0; --i) {
            num2 = num2.multiply(B[i]).add(N[i]);
        }
        return num2;
    }

    public static BigInteger toNum(BigInteger[] B, BigInteger[] N) {
        return Combinatorics.toNum(B, N, B.length);
    }

    public static BigInteger[] toSeq(BigInteger[] B, BigInteger n, int len) {
        Assert.check(B.length >= len && len != 0, 2134);
        BigInteger[] nlist = new BigInteger[len];
        BigInteger num2 = n;
        BigInteger base = B[0];
        nlist[0] = num2.remainder(base);
        for (int i = 1; i < len; ++i) {
            num2 = num2.divide(base);
            base = B[i];
            nlist[i] = num2.remainder(base);
        }
        return nlist;
    }

    public static BigInteger[] toSeq(BigInteger[] B, BigInteger n) {
        return Combinatorics.toSeq(B, n, B.length);
    }

    public static BigInteger fact(int n) {
        BigInteger result = BigInt.BigOne;
        for (int i = n; i > 1; --i) {
            result = result.multiply(BigInteger.valueOf(i));
        }
        return result;
    }

    public static BigInteger bigChoose(int n, int m) {
        if (n < 62 && m < 62) {
            return BigInteger.valueOf(Combinatorics.choose(n, m));
        }
        BigInteger binomial = BigInteger.ONE;
        int i = 1;
        int j = n;
        while (i <= m) {
            BigInteger bj = BigInteger.valueOf(j);
            BigInteger bi = BigInteger.valueOf(i);
            binomial = binomial.multiply(bj).divide(bi);
            ++i;
            --j;
        }
        return binomial;
    }

    public static BigInteger slowBigChoose(int n, int m) {
        BigInteger num2 = Combinatorics.fact(n);
        BigInteger denom = Combinatorics.fact(n - m).multiply(Combinatorics.fact(m));
        return num2.divide(denom);
    }

    public static BigInteger bigSumChoose(int n, int m) {
        BigInteger result;
        if (n / 2 >= m) {
            result = BigInt.BigZero;
            for (int i = 0; i <= m; ++i) {
                result = result.add(Combinatorics.bigChoose(n, i));
            }
        } else {
            result = BigInt.BigOne;
            result = result.shiftLeft(n);
            for (int i = m + 1; i <= n; ++i) {
                result = result.subtract(Combinatorics.bigChoose(n, i));
            }
        }
        return result;
    }

    public static String print(BigInteger[] A) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < A.length; ++i) {
            sb.append(A[i].toString());
            sb.append(", ");
        }
        return new String(sb);
    }

    public static final long binomial(int n, int k) {
        if (k > n) {
            return 0L;
        }
        if (k > n - k) {
            k = n - k;
        }
        long binomial = 1L;
        int i = 1;
        int m = n;
        while (i <= k) {
            binomial = binomial * (long)m / (long)i;
            ++i;
            --m;
        }
        return binomial;
    }

    public static long[] pascalTableUpTo(int maxN, int maxK) {
        if (maxN > 62) {
            long[] ppt = new long[(maxN - 62) * (maxK - 1)];
            int idx = 0;
            int i = 63;
            for (int j = 2; j <= maxK; ++j) {
                ppt[idx++] = Combinatorics.choose(i, j);
            }
            int k = maxK - 1;
            for (int j = 1; j < maxN - 62; ++j) {
                for (int l = 0; l < k; ++l) {
                    ppt[idx] = l == 0 ? (long)i++ + ppt[idx - k] : ppt[idx - k] + ppt[idx - k - 1];
                    ++idx;
                }
            }
            return ppt;
        }
        return new long[0];
    }

    static {
        int n = 4;
        int m = 2;
        long sum = 5L;
        for (int i = 0; i < 1770; ++i) {
            Combinatorics.CHOOSETABLE[i] = Combinatorics.choose(n - 1, m) + Combinatorics.choose(n - 1, m - 1);
            Combinatorics.SUMCHOOSETABLE[i] = sum += CHOOSETABLE[i];
            if (n == m + 2) {
                m = 2;
                sum = 1 + ++n;
                continue;
            }
            ++m;
        }
    }
}

