/*
 * Decompiled with CFR 0.152.
 */
package util;

import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.StackTrace;
import jdk.jfr.Unsigned;

public class TLAFlightRecorder {
    public static void progress(boolean isFinal, int diameter, long states, long distinctStates, long unseen, long statesPerMinute, long distinctStatesPerMinute) {
        try {
            ProgressEvent e2 = new ProgressEvent();
            e2.isFinal = isFinal;
            e2.spm = statesPerMinute;
            e2.dspm = distinctStatesPerMinute;
            e2.diameter = diameter;
            e2.unseen = unseen;
            e2.states = states;
            e2.distStates = distinctStates;
            e2.commit();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static String message(String message) {
        try {
            MessageEvent e2 = new MessageEvent();
            e2.message = message;
            e2.commit();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return message;
    }

    @Label(value="Message")
    @Category(value={"TLC"})
    @StackTrace(value=false)
    private static class MessageEvent
    extends Event {
        @Label(value="Message")
        public String message;

        private MessageEvent() {
        }
    }

    @Label(value="Progress")
    @Category(value={"TLC", "Progress"})
    @StackTrace(value=false)
    private static class ProgressEvent
    extends Event {
        @Label(value="States generated per minute")
        @Unsigned
        private long spm;
        @Label(value="Distinct states generated per minute")
        @Unsigned
        private long dspm;
        @Label(value="Unseen States")
        @Unsigned
        private long unseen;
        @Label(value="Diameter")
        @Unsigned
        private int diameter;
        @Label(value="States Generated")
        @Unsigned
        private long states;
        @Label(value="Distinct States Generated")
        @Unsigned
        private long distStates;
        @Label(value="Model Checking done")
        private boolean isFinal;

        private ProgressEvent() {
        }
    }
}

