/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.FileTypeMap;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static final String DEFAULT_TYPE = "application/octet-stream";
    private final Map types;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimetypesFileTypeMap() {
        FileInputStream is2;
        File file2;
        block28: {
            this.types = new HashMap();
            try {
                InputStream is3 = MimetypesFileTypeMap.class.getResourceAsStream("/META-INF/mimetypes.default");
                if (is3 == null) break block28;
                try {
                    this.loadStream(is3);
                }
                finally {
                    is3.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        try {
            ClassLoader cl = MimetypesFileTypeMap.class.getClassLoader();
            Enumeration<URL> e3 = cl.getResources("/META-INF/mime.types");
            while (e3.hasMoreElements()) {
                URL url = e3.nextElement();
                try {
                    InputStream is4 = url.openStream();
                    try {
                        this.loadStream(is4);
                    }
                    finally {
                        is4.close();
                    }
                }
                catch (IOException e1) {}
            }
        }
        catch (SecurityException e4) {
        }
        catch (IOException e5) {
            // empty catch block
        }
        try {
            file2 = new File(System.getProperty("java.home"), "lib/mime.types");
            is2 = new FileInputStream(file2);
            try {
                this.loadStream(is2);
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        catch (SecurityException e6) {
        }
        catch (FileNotFoundException e7) {
        }
        catch (IOException e8) {
            // empty catch block
        }
        try {
            file2 = new File(System.getProperty("user.home"), ".mime.types");
            is2 = new FileInputStream(file2);
            try {
                this.loadStream(is2);
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        catch (SecurityException e9) {
        }
        catch (FileNotFoundException e10) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        this();
        BufferedReader reader2 = new BufferedReader(new FileReader(mimeTypeFileName));
        try {
            String line;
            while ((line = reader2.readLine()) != null) {
                this.addMimeTypes(line);
            }
            reader2.close();
        }
        catch (IOException e2) {
            try {
                reader2.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e2;
        }
    }

    public MimetypesFileTypeMap(InputStream is2) {
        this();
        try {
            this.loadStream(is2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadStream(InputStream is2) throws IOException {
        String line;
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(is2));
        while ((line = reader2.readLine()) != null) {
            this.addMimeTypes(line);
        }
    }

    public synchronized void addMimeTypes(String mime_types) {
        StringTokenizer tok;
        int hashPos = mime_types.indexOf(35);
        if (hashPos != -1) {
            mime_types = mime_types.substring(0, hashPos);
        }
        if (!(tok = new StringTokenizer(mime_types)).hasMoreTokens()) {
            return;
        }
        String contentType = tok.nextToken();
        while (tok.hasMoreTokens()) {
            String fileType = tok.nextToken();
            this.types.put(fileType, contentType);
        }
    }

    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    public synchronized String getContentType(String filename) {
        int index2 = filename.lastIndexOf(46);
        if (index2 == -1 || index2 == filename.length() - 1) {
            return DEFAULT_TYPE;
        }
        String fileType = filename.substring(index2 + 1);
        String contentType = (String)this.types.get(fileType);
        return contentType == null ? DEFAULT_TYPE : contentType;
    }
}

