/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import tla2sany.parser.Operator;
import util.UniqueString;

public class Operators {
    public static int assocNone = 0;
    public static int assocLeft = 1;
    public static int assocRight = 2;
    public static int nofix = 0;
    public static int prefix = 1;
    public static int postfix = 2;
    public static int infix = 3;
    public static int nfix = 4;
    static Hashtable DefinitionTable = new Hashtable();
    static Hashtable BuiltinTable = new Hashtable();

    public static void addOperator(UniqueString name2, Operator op) {
        DefinitionTable.put(name2, op);
    }

    public static Operator getOperator(UniqueString name2) {
        return (Operator)DefinitionTable.get(name2);
    }

    public static Operator getMixfix(Operator op) {
        if (op.isPrefix()) {
            return op;
        }
        UniqueString id = UniqueString.uniqueStringOf(op.getIdentifier().toString() + ".");
        return (Operator)DefinitionTable.get(id);
    }

    public static boolean existsOperator(UniqueString name2) {
        return DefinitionTable.get(name2) != null;
    }

    public static void addSynonym(UniqueString template2, UniqueString match) {
        Operator n = (Operator)DefinitionTable.get(match);
        if (n != null) {
            DefinitionTable.put(template2, n);
        }
    }

    public static UniqueString resolveSynonym(UniqueString name2) {
        Operator n = (Operator)DefinitionTable.get(name2);
        if (n == null) {
            return name2;
        }
        return n.getIdentifier();
    }

    public static void addBuiltinAssoc(UniqueString symbol2, UniqueString builtin) {
        BuiltinTable.put(symbol2, builtin);
    }

    public static UniqueString getBuiltinAssoc(UniqueString symbol2) {
        Operator n = (Operator)DefinitionTable.get(symbol2);
        if (n != null) {
            UniqueString name2 = n.getIdentifier();
            return (UniqueString)BuiltinTable.get(name2);
        }
        return null;
    }

    public static void printTable() {
        System.out.println("printing Operators table");
        Enumeration Enum2 = DefinitionTable.keys();
        while (Enum2.hasMoreElements()) {
            System.out.println("-> " + ((UniqueString)Enum2.nextElement()).toString());
        }
    }
}

