/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCTrace;
import tlc2.tool.TraceApp;
import tlc2.tool.Worker;
import tlc2.tool.WorkerException;
import tlc2.util.LongVec;

public class ConcurrentTLCTrace
extends TLCTrace {
    private final Worker[] workers = new Worker[TLCGlobals.getNumWorkers()];

    public ConcurrentTLCTrace(String metadir, String specFile, TraceApp tool) throws IOException {
        super(metadir, specFile, tool);
    }

    public Worker addWorker(Worker worker) {
        this.workers[worker.myGetId()] = worker;
        return worker;
    }

    @Override
    public final int getLevelForReporting() throws IOException {
        return this.getLevel();
    }

    @Override
    public final synchronized int getLevel() throws IOException {
        int maxLevel = 1;
        for (Worker worker : this.workers) {
            maxLevel = Math.max(maxLevel, worker.getMaxLevel());
        }
        return maxLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLCStateInfo[] getTrace(TLCState state) throws IOException {
        if (state.isInitial()) {
            return new TLCStateInfo[]{new TLCStateInfo(state)};
        }
        LongVec fps = new LongVec();
        ConcurrentTLCTrace concurrentTLCTrace = this;
        synchronized (concurrentTLCTrace) {
            Record record = Record.getPredecessor(state, this.workers);
            while (!record.isInitial()) {
                fps.addElement(record.fp);
                record = record.getPredecessor();
            }
            fps.addElement(record.fp);
            assert (0 <= fps.size() && fps.size() <= this.getLevel());
        }
        return this.getTrace(fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLCStateInfo[] getTrace(TLCState from, TLCState to) throws IOException {
        if (to.isInitial() || from.equals(to)) {
            return new TLCStateInfo[]{new TLCStateInfo(to)};
        }
        LongVec fps = new LongVec();
        ConcurrentTLCTrace concurrentTLCTrace = this;
        synchronized (concurrentTLCTrace) {
            Record record = Record.getPredecessor(to, this.workers);
            while (record.fp != from.fingerPrint()) {
                fps.addElement(record.fp);
                record = record.getPredecessor();
            }
            fps.addElement(record.fp);
            assert (0 <= fps.size() && fps.size() <= this.getLevel());
        }
        return this.getTrace(new TLCStateInfo(from), fps);
    }

    @Override
    public void printTrace(TLCState s1, TLCState s2) throws IOException, WorkerException {
        if (s1.isInitial()) {
            this.printTrace(s1, s2, new TLCStateInfo[0]);
        } else {
            this.printTrace(s1, s2, this.getTrace(s1));
        }
    }

    @Override
    public synchronized void beginChkpt() throws IOException {
        for (Worker worker : this.workers) {
            worker.beginChkpt();
        }
    }

    @Override
    public void commitChkpt() throws IOException {
        for (Worker worker : this.workers) {
            worker.commitChkpt();
        }
    }

    @Override
    public void recover() throws IOException {
        for (Worker worker : this.workers) {
            worker.recover();
        }
    }

    @Override
    public synchronized TLCTrace.Enumerator elements() throws IOException {
        final Worker.Enumerator[] enums = new Worker.Enumerator[this.workers.length];
        for (int j = 0; j < this.workers.length; ++j) {
            enums[j] = this.workers[j].elements();
        }
        return new TLCTrace.Enumerator(){
            private int idx = 0;

            @Override
            public long nextPos() {
                if (this.idx >= ConcurrentTLCTrace.this.workers.length) {
                    return -1L;
                }
                if (enums[this.idx].hasMoreFP()) {
                    return 42L;
                }
                if (this.idx + 1 >= ConcurrentTLCTrace.this.workers.length) {
                    return -1L;
                }
                ++this.idx;
                return enums[this.idx].hasMoreFP() ? 42L : -1L;
            }

            @Override
            public long nextFP() throws IOException {
                if (!enums[this.idx].hasMoreFP()) {
                    ++this.idx;
                }
                return enums[this.idx].nextFP();
            }

            @Override
            public void close() throws IOException {
                for (Worker.Enumerator enumerator : enums) {
                    enumerator.close();
                }
            }

            @Override
            public void reset(long i) throws IOException {
                this.idx = 0;
            }
        };
    }

    public static class Record {
        private final long ptr;
        private final int worker;
        private final long fp;
        private Worker[] workers;

        static Record getPredecessor(TLCState state, Worker[] workers) throws IOException {
            Record record = workers[state.workerId].readStateRecord(state.uid);
            record.workers = workers;
            return record.getPredecessor();
        }

        public Record(long ptr, int worker, long fp) {
            this.ptr = ptr;
            this.worker = worker;
            this.fp = fp;
        }

        public Worker getWorker() {
            return this.workers[this.worker];
        }

        public boolean isInitial() {
            return this.ptr == 1L;
        }

        public String toString() {
            return "Record [ptr=" + this.ptr + ", worker=" + this.worker + ", fp=" + this.fp + ", initial=" + this.isInitial() + "]";
        }

        Record getPredecessor() throws IOException {
            Record record = this.getWorker().readStateRecord(this.ptr);
            record.workers = this.workers;
            return record;
        }
    }
}

