/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.util.Enumeration;
import tlc2.util.Vect;
import tlc2.value.IMVPerm;
import tlc2.value.IModelValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.MVPerm;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import util.Assert;
import util.Set;

public abstract class MVPerms {
    public static final IMVPerm[] permutationSubgroup(Enumerable enumerable) {
        Value elem;
        ValueEnumeration Enum2 = enumerable.elements();
        int sz = enumerable.size() - 1;
        Set perms = new Set(sz);
        Vect<IMVPerm> permVec = new Vect<IMVPerm>(sz);
        while ((elem = Enum2.nextElement()) != null) {
            FcnRcdValue fcn = (FcnRcdValue)elem.toFcnRcd();
            if (fcn == null) {
                Assert.fail("The symmetry operator must specify a set of functions.");
            }
            MVPerm perm = new MVPerm();
            for (int i = 0; i < fcn.domain.length; ++i) {
                Value dval = fcn.domain[i];
                Value rval = fcn.values[i];
                if (dval instanceof ModelValue && rval instanceof ModelValue) {
                    perm.put((ModelValue)dval, (IModelValue)((ModelValue)rval));
                    continue;
                }
                Assert.fail("Symmetry function must have model values as domain and range.");
            }
            if (perm.size() <= 0 || perms.put(perm) != null) continue;
            permVec.addElement(perm);
        }
        int gsz = permVec.size();
        int sz0 = 0;
        while (true) {
            int sz1 = permVec.size();
            for (int i = 0; i < gsz; ++i) {
                IMVPerm perm1 = (IMVPerm)permVec.elementAt(i);
                for (int j = sz0; j < sz1; ++j) {
                    IMVPerm perm = perm1.compose((IMVPerm)permVec.elementAt(j));
                    if (perm.size() <= 0 || perms.put(perm) != null) continue;
                    permVec.addElement(perm);
                }
            }
            if (sz1 == permVec.size()) break;
            sz0 = sz1;
        }
        IMVPerm[] res2 = new IMVPerm[permVec.size()];
        Enumeration permEnum = permVec.elements();
        for (int i = 0; i < res2.length; ++i) {
            res2[i] = (IMVPerm)permEnum.nextElement();
        }
        return res2;
    }
}

