/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcal.AST;
import pcal.IntPair;
import pcal.ParseAlgorithm;
import pcal.PcalCharReader;
import pcal.PcalDebug;
import pcal.PcalParams;
import pcal.TLAtoPCalMapping;
import pcal.exception.ParseAlgorithmException;
import pcal.trans;

public class Validator {
    protected static boolean PRE_TRIM_VALIDATION_CONTENT = true;
    static final Pattern PCAL_CHECKSUM_PATTERN = Pattern.compile("PCal-[0-9a-f]+$");
    static final Pattern TRANSLATED_PCAL_CHECKSUM_PATTERN = Pattern.compile("TLA-[0-9a-f]+$");
    private static final Pattern MODULE_PREFIX_PATTERN = Pattern.compile("^([-]+ MODULE) ");
    private static final Pattern MODULE_CLOSING_PATTERN = Pattern.compile("^[=]+$");
    private static final Pattern PLUSCAL_OPTIONS = Pattern.compile("^[\\s]*PlusCal[\\s]+options", 2);

    public static ValidationResult validate(InputStream inputStream) throws IOException {
        int bytesRead;
        BufferedInputStream bis;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        BufferedInputStream bufferedInputStream = bis = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        while ((bytesRead = bis.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        String specContents = new String(baos.toByteArray(), "UTF-8");
        String[] lines = specContents.split("\\r?\\n");
        int startLine = -1;
        if (PRE_TRIM_VALIDATION_CONTENT) {
            for (int i = 0; i < lines.length; ++i) {
                Matcher m = MODULE_PREFIX_PATTERN.matcher(lines[i]);
                if (m.find()) {
                    startLine = i;
                    break;
                }
                Matcher m2 = PLUSCAL_OPTIONS.matcher(lines[i]);
                if (!m2.find()) continue;
                startLine = i;
                break;
            }
        }
        if (startLine < 1) {
            return Validator.validate(Arrays.asList(lines));
        }
        int reducedLength = lines.length - startLine;
        String[] reducedLines = new String[reducedLength];
        System.arraycopy(lines, startLine, reducedLines, 0, reducedLength);
        return Validator.validate(Arrays.asList(reducedLines));
    }

    private static ValidationResult validate(List<String> specificationText) {
        AST ast;
        String line;
        Matcher m;
        Vector<String> deTabbedSpecification = trans.removeTabs(specificationText);
        IntPair searchLoc = new IntPair(0, 0);
        boolean notDone = true;
        while (notDone) {
            try {
                ParseAlgorithm.FindToken("PlusCal", deTabbedSpecification, searchLoc, "");
                String line2 = ParseAlgorithm.GotoNextNonSpace(deTabbedSpecification, searchLoc);
                String restOfLine = line2.substring(searchLoc.two);
                if (!restOfLine.startsWith("options") || ParseAlgorithm.NextNonIdChar(restOfLine, 0) != 7) continue;
                PcalParams.optionsInFile = true;
                ParseAlgorithm.ProcessOptions(deTabbedSpecification, searchLoc);
                notDone = false;
            }
            catch (ParseAlgorithmException e2) {
                notDone = false;
            }
        }
        int algLine = 0;
        int algCol = -1;
        boolean foundBegin = false;
        boolean foundFairBegin = false;
        while (algLine < deTabbedSpecification.size() && !foundBegin && !(m = MODULE_CLOSING_PATTERN.matcher(line = deTabbedSpecification.elementAt(algLine))).matches()) {
            algCol = line.indexOf("--algorithm");
            if (algCol != -1) {
                algCol += "--algorithm".length();
                foundBegin = true;
                continue;
            }
            algCol = line.indexOf("--fair");
            if (algCol != -1) {
                algCol += "--fair".length();
                foundBegin = true;
                foundFairBegin = true;
                continue;
            }
            ++algLine;
        }
        if (!foundBegin) {
            return ValidationResult.NO_PLUSCAL_EXISTS;
        }
        int translationLine = trans.findTokenPair(deTabbedSpecification, 0, "BEGIN", "TRANSLATION");
        if (translationLine == -1) {
            return ValidationResult.NO_TRANSLATION_EXISTS;
        }
        int endTranslationLine = trans.findTokenPair(deTabbedSpecification, translationLine + 1, "END", "TRANSLATION");
        if (endTranslationLine == -1) {
            return ValidationResult.NO_TRANSLATION_EXISTS;
        }
        String beginLine = deTabbedSpecification.get(translationLine);
        Matcher m2 = PCAL_CHECKSUM_PATTERN.matcher(beginLine);
        if (!m2.find()) {
            return ValidationResult.NO_CHECKSUMS_EXIST;
        }
        String pcalMD5 = beginLine.substring(m2.start() + "PCal-".length());
        String endLine = deTabbedSpecification.get(endTranslationLine);
        m2 = TRANSLATED_PCAL_CHECKSUM_PATTERN.matcher(endLine);
        if (m2.find()) {
            Vector<String> translation;
            String calculatedMD5;
            String translatedMD5 = endLine.substring(m2.start() + "TLA-".length());
            if (!translatedMD5.equals(calculatedMD5 = Validator.calculateMD5(translation = new Vector<String>(specificationText.subList(translationLine + 1, endTranslationLine))))) {
                return ValidationResult.DIVERGENCE_EXISTS;
            }
        } else {
            Object translatedMD5 = null;
        }
        try {
            ParseAlgorithm.uncomment(deTabbedSpecification, algLine, algCol);
        }
        catch (ParseAlgorithmException e3) {
            PcalDebug.reportError(e3);
            return ValidationResult.ERROR_ENCOUNTERED;
        }
        TLAtoPCalMapping mapping = new TLAtoPCalMapping();
        mapping.algColumn = algCol;
        mapping.algLine = algLine;
        PcalParams.tlaPcalMapping = mapping;
        PcalCharReader reader2 = new PcalCharReader(deTabbedSpecification, algLine, algCol, specificationText.size(), 0);
        try {
            ast = ParseAlgorithm.getAlgorithm(reader2, foundFairBegin);
        }
        catch (ParseAlgorithmException e4) {
            PcalDebug.reportError(e4);
            return ValidationResult.ERROR_ENCOUNTERED;
        }
        String calculatedMD5 = Validator.calculateMD5(ast.toString());
        if (!pcalMD5.equals(calculatedMD5)) {
            return ValidationResult.DIVERGENCE_EXISTS;
        }
        return ValidationResult.NO_DIVERGENCE;
    }

    static String calculateMD5(Vector<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String str2 : lines) {
            sb.append(str2);
        }
        return Validator.calculateMD5(sb.toString());
    }

    static String calculateMD5(String string2) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash2 = digest.digest(string2.getBytes(StandardCharsets.UTF_8));
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hash2.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash2[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e2) {
            PcalDebug.reportError("Unable to calculate MD5: " + e2.getMessage());
            return null;
        }
    }

    public static enum ValidationResult {
        NO_PLUSCAL_EXISTS,
        NO_TRANSLATION_EXISTS,
        NO_CHECKSUMS_EXIST,
        DIVERGENCE_EXISTS,
        ERROR_ENCOUNTERED,
        NO_DIVERGENCE;

    }
}

