/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.Location;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class Context
implements ExploreNode {
    private static Context initialContext = new Context(null, new Errors());
    private ExternalModuleTable exMT;
    private Errors errors;
    private Hashtable<Object, Pair> table = new Hashtable();
    private Pair lastPair;

    public Context(ExternalModuleTable mt, Errors errs) {
        this.exMT = mt;
        this.errors = errs;
        this.lastPair = null;
    }

    public static void reInit() {
        initialContext = new Context(null, new Errors());
    }

    public static Context getGlobalContext() {
        return initialContext;
    }

    public static boolean isBuiltIn(ExploreNode exploreNode) {
        Collection<Pair> pairs = Context.initialContext.table.values();
        for (Pair p : pairs) {
            if (exploreNode != p.info) continue;
            return true;
        }
        return false;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public static void addGlobalSymbol(UniqueString name2, SymbolNode sn, Errors errors) throws AbortException {
        if (initialContext.getSymbol(name2) == null) {
            initialContext.addSymbolToContext(name2, sn);
            return;
        }
        errors.addAbort(Location.nullLoc, "Error building initial context: Multiply-defined builtin operator " + name2 + " at " + sn, false);
    }

    public SymbolNode getSymbol(Object name2) {
        Pair r = this.table.get(name2);
        if (r != null) {
            return r.info;
        }
        return null;
    }

    public void addSymbolToContext(Object name2, SymbolNode s) {
        this.table.put(name2, new Pair(s));
    }

    public boolean occurSymbol(Object name2) {
        return this.table.containsKey(name2);
    }

    public Enumeration<Pair> content() {
        return this.table.elements();
    }

    public ContextSymbolEnumeration getContextSymbolEnumeration() {
        return new ContextSymbolEnumeration();
    }

    public Vector<SymbolNode> getByClass(Class<?> template2) {
        Vector<SymbolNode> result = new Vector<SymbolNode>();
        Enumeration<Pair> list = this.table.elements();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!template2.isInstance(elt.info)) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public Vector<OpDefNode> getOpDefs() {
        Pair nextPair = this.lastPair;
        Vector<OpDefNode> result = new Vector<OpDefNode>();
        while (nextPair != null) {
            if (nextPair.info instanceof OpDefNode && ((OpDefNode)nextPair.info).getKind() != 6 && ((OpDefNode)nextPair.info).getKind() != 7) {
                result.addElement((OpDefNode)nextPair.info);
            }
            nextPair = nextPair.link;
        }
        return result;
    }

    public Vector<ThmOrAssumpDefNode> getThmOrAssDefs() {
        Pair nextPair = this.lastPair;
        Vector<ThmOrAssumpDefNode> result = new Vector<ThmOrAssumpDefNode>();
        while (nextPair != null) {
            if (nextPair.info instanceof ThmOrAssumpDefNode) {
                result.addElement((ThmOrAssumpDefNode)nextPair.info);
            }
            nextPair = nextPair.link;
        }
        return result;
    }

    public Vector<SemanticNode> getConstantDecls() {
        Class<OpDeclNode> templateClass = OpDeclNode.class;
        Enumeration<Pair> list = this.table.elements();
        Vector<SemanticNode> result = new Vector<SemanticNode>();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!templateClass.isInstance(elt.info) || ((OpDeclNode)elt.info).getKind() != 2) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public Vector<SemanticNode> getVariableDecls() {
        Class<OpDeclNode> templateClass = OpDeclNode.class;
        Enumeration<Pair> list = this.table.elements();
        Vector<SemanticNode> result = new Vector<SemanticNode>();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!templateClass.isInstance(elt.info) || ((OpDeclNode)elt.info).getKind() != 3) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public Vector<SemanticNode> getModDefs() {
        Class<ModuleNode> template2 = ModuleNode.class;
        Enumeration<Pair> list = this.table.elements();
        Vector<SemanticNode> result = new Vector<SemanticNode>();
        while (list.hasMoreElements()) {
            Pair elt = list.nextElement();
            if (!template2.isInstance(elt.info)) continue;
            result.addElement(elt.info);
        }
        return result;
    }

    public boolean mergeExtendContext(Context ct) {
        if (ct.lastPair == null) {
            return true;
        }
        boolean erc = true;
        Pair p = ct.lastPair.reversePairList();
        while (p != null) {
            SymbolNode sn = p.info;
            if (!sn.isLocal()) {
                Object sName = sn instanceof ModuleNode ? new SymbolTable.ModuleName(sn.getName()) : sn.getName();
                if (!this.table.containsKey(sName)) {
                    this.table.put(sName, new Pair(sn));
                } else {
                    SymbolNode symbol2 = this.table.get((Object)sName).info;
                    if (symbol2 != sn) {
                        if (symbol2.getClass() == sn.getClass()) {
                            if (!symbol2.sameOriginallyDefinedInModule(sn)) {
                                this.errors.addWarning(sn.getTreeNode().getLocation(), "Warning: the " + Context.kindOfNode(symbol2) + " of '" + sName.toString() + "' conflicts with \nits " + Context.kindOfNode(symbol2) + " at " + symbol2.getTreeNode().getLocation() + ".");
                            }
                        } else {
                            this.errors.addError(sn.getTreeNode().getLocation(), "The " + Context.kindOfNode(symbol2) + " of '" + sName.toString() + "' conflicts with \nits " + Context.kindOfNode(symbol2) + " at " + symbol2.getTreeNode().getLocation() + ".");
                            erc = false;
                        }
                    }
                }
            }
            p = p.link;
        }
        return erc;
    }

    private static String kindOfNode(SymbolNode symbol2) {
        if (symbol2 instanceof OpDefNode) {
            return "definition";
        }
        if (symbol2 instanceof FormalParamNode) {
            return "definition";
        }
        return "declaration";
    }

    public Context duplicate(ExternalModuleTable exMT) {
        Context dup = new Context(exMT, this.errors);
        Pair p = this.lastPair;
        Pair current = null;
        boolean firstTime = true;
        while (p != null) {
            if (firstTime) {
                dup.lastPair = current = new Pair(null, p.info);
                firstTime = false;
            } else {
                current = current.link = new Pair(null, p.info);
            }
            dup.table.put(current.info.getName(), current);
            p = p.link;
        }
        return dup;
    }

    @Override
    public String levelDataToString() {
        return "Dummy level string";
    }

    @Override
    public String toString(int depth) {
        return "Please use Context.getContextEntryStringVector() instead of Context.toString()";
    }

    public Vector<String> getContextEntryStringVector(int depth, boolean b) {
        Vector<String> ctxtEntries = new Vector<String>(100);
        Context naturalsContext = this.exMT.getContext(UniqueString.uniqueStringOf("Naturals"));
        if (depth <= 0) {
            return ctxtEntries;
        }
        Pair p = this.lastPair;
        while (p != null) {
            UniqueString key2 = p.info.getName();
            if (b || !Context.initialContext.table.containsKey(key2) && (naturalsContext == null || !naturalsContext.table.containsKey(key2))) {
                SymbolNode symbNode = this.table.get((Object)key2).info;
                ctxtEntries.addElement("\nContext Entry: " + key2.toString() + "  " + String.valueOf(symbNode.myUID).toString() + " " + Strings.indentSB(2, symbNode.toString(depth - 1)));
            }
            p = p.link;
        }
        int n = ctxtEntries.size();
        for (int i = 0; i < n / 2; ++i) {
            String obj = ctxtEntries.elementAt(i);
            ctxtEntries.setElementAt(ctxtEntries.elementAt(n - 1 - i), i);
            ctxtEntries.setElementAt(obj, n - 1 - i);
        }
        return ctxtEntries;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        visitor.preVisit(this);
        Enumeration<Object> e2 = this.table.keys();
        while (e2.hasMoreElements()) {
            UniqueString key2;
            Object next2 = e2.nextElement();
            if (next2 instanceof SymbolTable.ModuleName) {
                key2 = ((SymbolTable.ModuleName)next2).name;
                System.out.println("Bug in debugging caused by inner module " + key2.toString());
                System.out.println("SANY will throw a null pointer exception.");
            } else {
                key2 = (UniqueString)next2;
                this.table.get((Object)key2).info.walkGraph(semNodesTable, visitor);
            }
            visitor.postVisit(this);
        }
    }

    static /* synthetic */ Context access$100() {
        return initialContext;
    }

    public class ContextSymbolEnumeration {
        Enumeration<Pair> e;

        public ContextSymbolEnumeration() {
            this.e = Context.this.content();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public SymbolNode nextElement() {
            return this.e.nextElement().getSymbol();
        }
    }

    public class InitialSymbolEnumeration {
        Enumeration<Pair> e = Context.access$100().content();

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public SymbolNode nextElement() {
            return this.e.nextElement().getSymbol();
        }
    }

    class Pair {
        Pair link;
        SymbolNode info;

        Pair(Pair lnk, SymbolNode inf) {
            this.link = lnk;
            this.info = inf;
        }

        Pair(SymbolNode inf) {
            this.link = Context.this.lastPair;
            this.info = inf;
            Context.this.lastPair = this;
        }

        public SymbolNode getSymbol() {
            return this.info;
        }

        public Pair reversePairList() {
            Pair curResult = new Pair(null, this.info);
            Pair nextOriginal = this.link;
            while (nextOriginal != null) {
                curResult = new Pair(curResult, nextOriginal.info);
                nextOriginal = nextOriginal.link;
            }
            return curResult;
        }
    }
}

