/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TypedSet {
    public static final TypedSet EMPTY_SET = new TypedSet();
    private static final String SEPARATOR = "_";
    private static final String PATTERN = "[\\s]*,[\\s]*";
    private String[] values = new String[0];
    private String type = null;

    public static TypedSet parseSet(String set2) {
        TypedSet result = new TypedSet();
        if (set2 == null) {
            return result;
        }
        if ((set2 = set2.trim()).length() > 0 && set2.charAt(0) == '{' && set2.charAt(set2.length() - 1) == '}') {
            set2 = set2.substring(1, set2.length() - 1);
            set2 = set2.trim();
        }
        if ("".equals(set2)) {
            return result;
        }
        String[] parsedSet = null;
        parsedSet = set2.split(PATTERN);
        if (parsedSet.length > 0) {
            int typeSeparatorPosition = parsedSet[0].indexOf(SEPARATOR);
            if (typeSeparatorPosition == -1 || typeSeparatorPosition == 0) {
                result.setValues(parsedSet);
                return result;
            }
            result.setType(parsedSet[0].substring(0, typeSeparatorPosition));
            parsedSet[0] = parsedSet[0].substring(typeSeparatorPosition + 1);
            boolean typePatternViolated = parsedSet[0].length() == 0;
            for (int i = 1; i < parsedSet.length; ++i) {
                if (parsedSet[i].startsWith(result.getType() + SEPARATOR)) {
                    parsedSet[i] = parsedSet[i].substring(typeSeparatorPosition + 1);
                    if (parsedSet[i].length() == 0) {
                        typePatternViolated = true;
                    }
                } else {
                    typePatternViolated = true;
                }
                if (typePatternViolated) break;
            }
            if (typePatternViolated) {
                result.setValues(set2.split(PATTERN));
                result.setType(null);
            } else {
                result.setValues(parsedSet);
            }
        }
        return result;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public static String getTypeOfId(String id) {
        if (id == null || id.length() < 2 || !id.substring(1, 2).equals(SEPARATOR)) {
            return null;
        }
        return id.substring(0, 1);
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void unsetType() {
        this.setType(null);
    }

    public boolean contains(String value) {
        if (value != null) {
            for (String aValue : this.values) {
                if (!value.equals(aValue)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getValues() {
        return this.values;
    }

    public List<String> getValuesAsList() {
        if (!this.hasType()) {
            return Arrays.asList(this.values);
        }
        ArrayList<String> typedList = new ArrayList<String>(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            String value = this.type + SEPARATOR + this.values[i];
            typedList.add(value);
        }
        return typedList;
    }

    public int getValueCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public String getValue(int index2) {
        if (index2 >= this.getValueCount()) {
            return null;
        }
        return (this.hasType() ? this.getType() + SEPARATOR : "") + this.values[index2];
    }

    public void setValues(String[] values) {
        this.values = values == null ? new String[0] : values;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + TypedSet.hashCode(this.values);
        return result;
    }

    private static int hashCode(Object[] array2) {
        int prime = 31;
        if (array2 == null) {
            return 0;
        }
        int result = 1;
        for (int index2 = 0; index2 < array2.length; ++index2) {
            result = prime * result + (array2[index2] == null ? 0 : array2[index2].hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedSet other = (TypedSet)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        for (int i = 0; i < this.values.length; ++i) {
            if (this.type != null) {
                buffer.append(this.type).append(SEPARATOR);
            }
            buffer.append(this.values[i]);
            if (i == this.values.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toStringWithoutBraces() {
        String set2 = this.toString();
        return set2.substring(1, set2.length() - 1);
    }

    public boolean hasANumberOnlyValue() {
        if (this.hasType()) {
            return !this.hasValidType();
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].matches("[0-9]*")) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidType() {
        return this.type == null || this.type.matches("[A-Za-z]{1}[A-Za-z0-9]*");
    }
}

