/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.selector;

import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.selector.BlockSelector;
import tlc2.tool.distributed.selector.IBlockSelector;
import tlc2.tool.distributed.selector.LimitingBlockSelector;
import tlc2.tool.distributed.selector.StaticBlockSelector;
import tlc2.tool.distributed.selector.StatisticalBlockSelector;

public class BlockSelectorFactory {
    private static final String FACTORY_NAME = System.getProperty("tlc2.tool.distributed.selector.factory");
    private static final String STATIC_SELECTOR = System.getProperty("tlc2.tool.distributed.selector.bsf.staticselector");
    private static final String UNLIMITING_SELECTOR = System.getProperty("tlc2.tool.distributed.selector.bsf.unlimitingselector");
    private static final String LIMITING_SELECTOR = System.getProperty("tlc2.tool.distributed.selector.bsf.limitingselector");

    public static IBlockSelector getBlockSelector(TLCServer aTLCServer) {
        BlockSelectorFactory bsf = new BlockSelectorFactory();
        if (FACTORY_NAME != null) {
            bsf = BlockSelectorFactory.loadCustomFactory(FACTORY_NAME, bsf);
        }
        return bsf.getSelector(aTLCServer);
    }

    private static BlockSelectorFactory loadCustomFactory(String clazz, BlockSelectorFactory bsf) {
        try {
            ClassLoader classLoader = BlockSelectorFactory.class.getClassLoader();
            Class<?> factoryClass = classLoader.loadClass(clazz);
            Object instance = factoryClass.newInstance();
            if (instance instanceof BlockSelectorFactory) {
                bsf = (BlockSelectorFactory)instance;
            }
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (InstantiationException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
        }
        return bsf;
    }

    protected IBlockSelector getSelector(TLCServer aTLCServer) {
        if (Boolean.parseBoolean(STATIC_SELECTOR)) {
            return new StaticBlockSelector(aTLCServer);
        }
        if (Boolean.parseBoolean(UNLIMITING_SELECTOR)) {
            return new BlockSelector(aTLCServer);
        }
        if (Boolean.parseBoolean(LIMITING_SELECTOR)) {
            return new LimitingBlockSelector(aTLCServer);
        }
        return new StatisticalBlockSelector(aTLCServer);
    }
}

