/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;

public class AssumeNode
extends LevelNode {
    ModuleNode module;
    ExprNode assumeExpr;
    private ThmOrAssumpDefNode def;
    private boolean isAxiom = false;
    int levelChecked = 0;

    public boolean getIsAxiom() {
        return this.isAxiom;
    }

    public AssumeNode(TreeNode stn, ExprNode expr, ModuleNode mn, ThmOrAssumpDefNode opd) {
        super(20, stn);
        this.assumeExpr = expr;
        this.module = mn;
        this.def = opd;
        if (stn.heirs()[0].getImage().equals("AXIOM")) {
            this.isAxiom = true;
        }
        if (opd != null) {
            opd.thmOrAssump = this;
        }
    }

    public final ExprNode getAssume() {
        return this.assumeExpr;
    }

    public final ThmOrAssumpDefNode getDef() {
        return this.def;
    }

    @Override
    public final boolean levelCheck(int iter) {
        if (this.levelChecked >= iter) {
            return true;
        }
        this.levelChecked = iter;
        boolean res2 = this.assumeExpr.levelCheck(iter);
        if (this.def != null) {
            boolean bl = res2 = this.def.levelCheck(iter) && res2;
        }
        if (this.assumeExpr.getLevel() != 0) {
            errors.addError(this.getTreeNode().getLocation(), "Level error: assumptions must be level 0 (Constant), \nbut this one has level " + this.getLevel() + ".");
        }
        if (res2) {
            AssumeNode.addTemporalLevelConstraintToConstants(this.levelParams, this.levelConstraints);
        }
        return res2;
    }

    @Override
    public final int getLevel() {
        return this.assumeExpr.getLevel();
    }

    @Override
    public final HashSet<SymbolNode> getLevelParams() {
        return this.assumeExpr.getLevelParams();
    }

    @Override
    public final HashSet<SymbolNode> getAllParams() {
        return this.assumeExpr.getAllParams();
    }

    @Override
    public final SetOfLevelConstraints getLevelConstraints() {
        return this.assumeExpr.getLevelConstraints();
    }

    @Override
    public final SetOfArgLevelConstraints getArgLevelConstraints() {
        return this.assumeExpr.getArgLevelConstraints();
    }

    @Override
    public final HashSet<ArgLevelParam> getArgLevelParams() {
        return this.assumeExpr.getArgLevelParams();
    }

    @Override
    public final String levelDataToString() {
        return "Level: " + this.getLevel() + "\nLevelParameters: " + this.getLevelParams() + "\nLevelConstraints: " + this.getLevelConstraints() + "\nArgLevelConstraints: " + this.getArgLevelConstraints() + "\nArgLevelParams: " + this.getArgLevelParams() + "\n";
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String res2 = Strings.indent(2, "\n*AssumeNode " + super.toString(depth) + (this.assumeExpr != null ? Strings.indent(2, this.assumeExpr.toString(depth - 1)) : ""));
        if (this.def != null) {
            res2 = res2 + Strings.indent(4, "\n def: " + Strings.indent(2, this.def.toString(depth - 1)));
        }
        return res2;
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.assumeExpr};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.assumeExpr != null) {
            this.assumeExpr.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    public Element exportDefinition(Document doc2, SymbolContext context) {
        if (!context.isTop_level_entry()) {
            throw new IllegalArgumentException("Exporting theorem ref " + this.getNodeRef() + " twice!");
        }
        context.resetTop_level_entry();
        try {
            Element e2 = this.getLevelElement(doc2, context);
            try {
                Element l = this.appendText(doc2, "level", Integer.toString(this.getLevel()));
                e2.insertBefore(l, e2.getFirstChild());
            }
            catch (RuntimeException l) {
                // empty catch block
            }
            try {
                Element loc = this.getLocationElement(doc2);
                e2.insertBefore(loc, e2.getFirstChild());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return e2;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }

    protected String getNodeRef() {
        return "AssumeNodeRef";
    }

    @Override
    protected Element getLevelElement(Document doc2, SymbolContext context) {
        Element e2 = doc2.createElement("AssumeNode");
        if (this.def != null) {
            Element d = doc2.createElement("definition");
            d.appendChild(this.def.export(doc2, context));
            e2.appendChild(d);
            assert (this.def.getBody() == this.assumeExpr);
        }
        Element n = doc2.createElement("body");
        n.appendChild(this.getAssume().export(doc2, context));
        e2.appendChild(n);
        return e2;
    }

    @Override
    public Element export(Document doc2, SymbolContext context) {
        context.put(this, doc2);
        Element e2 = doc2.createElement(this.getNodeRef());
        e2.appendChild(this.appendText(doc2, "UID", Integer.toString(this.myUID)));
        return e2;
    }
}

