/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.Context;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.utilities.Stack;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class SymbolTable
implements ASTConstants {
    private Stack contextStack;
    private Context topContext;
    private Context baseContext;
    private ExternalModuleTable mt;
    private ModuleNode modNode;
    private Errors errors;

    public SymbolTable(ExternalModuleTable mt, Errors errs) {
        this.baseContext = this.topContext = Context.getGlobalContext().duplicate(mt);
        this.errors = errs;
        this.contextStack = new Stack();
        this.contextStack.push(this.topContext);
        this.mt = mt;
    }

    public SymbolTable(ExternalModuleTable mt, Errors errs, SymbolTable st) {
        this.modNode = st.modNode;
        this.errors = errs;
        this.contextStack = new Stack();
        for (int i = 0; i < st.contextStack.size(); ++i) {
            this.contextStack.push(st.contextStack.elementAt(i));
        }
        this.baseContext = (Context)this.contextStack.elementAt(0);
        this.mt = mt;
    }

    public final Context getExternalContext() {
        return this.baseContext;
    }

    public final Context getContext() {
        return this.topContext;
    }

    public final void pushContext(Context ct) {
        this.contextStack.push(ct);
        this.topContext = ct;
    }

    public final void popContext() {
        this.contextStack.pop();
        this.topContext = (Context)this.contextStack.peek();
    }

    public final void setModuleNode(ModuleNode mn) {
        this.modNode = mn;
    }

    public final ModuleNode getModuleNode() {
        return this.modNode;
    }

    public final SymbolNode resolveSymbol(UniqueString name2) {
        for (int c = this.contextStack.size() - 1; c >= 0; --c) {
            Context ct = (Context)this.contextStack.elementAt(c);
            SymbolNode r = ct.getSymbol(name2);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public final ModuleNode resolveModule(UniqueString name2) {
        ModuleName modName = new ModuleName(name2);
        for (int c = this.contextStack.size() - 1; c >= 0; --c) {
            Context ct = (Context)this.contextStack.elementAt(c);
            SymbolNode res2 = ct.getSymbol(modName);
            if (res2 == null) continue;
            return (ModuleNode)res2;
        }
        return this.mt.getModuleNode(name2);
    }

    public final boolean addSymbol(UniqueString name2, SymbolNode symbol2) {
        SymbolNode currentBinding = this.resolveSymbol(name2);
        if (currentBinding == symbol2) {
            return true;
        }
        if (currentBinding == null) {
            this.topContext.addSymbolToContext(name2, symbol2);
            return true;
        }
        if (symbol2.getKind() == 11 || symbol2.getKind() == 4 || currentBinding.getKind() != symbol2.getKind() || currentBinding.getArity() != symbol2.getArity()) {
            this.errors.addError(symbol2.getTreeNode().getLocation(), "Multiply-defined symbol '" + name2 + "': this definition or declaration conflicts \nwith the one at " + currentBinding.getTreeNode().getLocation().toString() + ".");
            return false;
        }
        if (currentBinding.getTreeNode().getLocation().source().equals("--TLA+ BUILTINS--")) {
            this.errors.addError(symbol2.getTreeNode().getLocation(), "Symbol " + name2 + " is a built-in operator, and cannot be redefined.");
            return false;
        }
        if (symbol2.sameOriginallyDefinedInModule(currentBinding)) {
            return true;
        }
        this.errors.addWarning(symbol2.getTreeNode().getLocation(), "Multiple declarations or definitions for symbol " + name2 + ".  \nThis duplicates the one at " + currentBinding.getTreeNode().getLocation().toString() + ".");
        return true;
    }

    public final boolean addModule(UniqueString name2, ModuleNode symbol2) {
        ModuleNode currentBinding = this.resolveModule(name2);
        if (currentBinding == symbol2) {
            return true;
        }
        if (currentBinding == null) {
            ModuleName modName = new ModuleName(name2);
            this.topContext.addSymbolToContext(modName, symbol2);
            return true;
        }
        this.errors.addError(symbol2.getTreeNode().getLocation(), "Multiply-defined module '" + name2 + "': this definition or declaration conflicts \nwith the one at " + currentBinding.getTreeNode().getLocation().toString() + ".");
        return false;
    }

    public String toString() {
        String ret = "\n\n***SymbolTable\n\n*** top context";
        for (int c = this.contextStack.size() - 1; c >= 0; --c) {
            Context ct = (Context)this.contextStack.elementAt(c);
            Vector<String> v = ct.getContextEntryStringVector(1, true);
            for (int i = 0; i < v.size(); ++i) {
                ret = ret + v.elementAt(i);
            }
            ret = ret + "\n\n*** next context\n";
        }
        return ret;
    }

    static class ModuleName {
        UniqueString name;

        ModuleName(UniqueString name2) {
            this.name = name2;
        }

        public final int hashCode() {
            return this.name.hashCode();
        }

        public final boolean equals(Object obj) {
            return obj instanceof ModuleName && this.name.equals(((ModuleName)obj).name);
        }

        public final String toString() {
            return this.name.toString();
        }
    }
}

