/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.io.FileWriter;
import java.io.IOException;
import tla2tex.Debug;

public class OutputFileWriter {
    private FileWriter fileWriter = null;
    private String name = "";

    public OutputFileWriter(String fileName) {
        this.name = fileName;
        try {
            this.fileWriter = new FileWriter(fileName);
        }
        catch (IOException e2) {
            Debug.ReportError("TLATeX cannot open output file " + this.name + ".\n    Perhaps the file is write-protected");
        }
    }

    public void putLine(String out) {
        try {
            this.fileWriter.write(out + "\n");
            this.fileWriter.flush();
        }
        catch (IOException e2) {
            Debug.ReportError("Error trying to write to output file " + this.name + ".\n    Perhaps there is a file-system problem.");
        }
    }

    public void close() {
        try {
            this.fileWriter.close();
        }
        catch (IOException e2) {
            Debug.ReportError("Error trying to close output file " + this.name + ".\n    Perhaps there is a file-system problem.");
        }
    }
}

