/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.tool.liveness.TBPar;
import tlc2.tool.liveness.TBParVec;
import tlc2.util.Vect;

public class TBGraph
extends Vect<TBGraphNode> {
    public final LiveExprNode tf;
    private int initCnt;

    public TBGraph() {
        this.tf = null;
        this.initCnt = 0;
    }

    public TBGraph(LiveExprNode tf) {
        int i;
        this.tf = tf;
        this.initCnt = 0;
        TBPar initTerms = new TBPar(1);
        initTerms.addElement(tf);
        TBParVec pars = initTerms.particleClosure();
        for (i = 0; i < pars.size(); ++i) {
            TBGraphNode gn = new TBGraphNode(pars.parAt(i));
            this.addElement(gn);
        }
        this.setInitCnt(this.size());
        for (i = 0; i < this.size(); ++i) {
            TBGraphNode gnSrc = (TBGraphNode)this.elementAt(i);
            TBPar imps = gnSrc.getPar().impliedSuccessors();
            TBParVec succs = imps.particleClosure();
            for (int j = 0; j < succs.size(); ++j) {
                TBPar par = succs.parAt(j);
                TBGraphNode gnDst = this.findOrCreateNode(par);
                gnSrc.nexts.addElement(gnDst);
            }
        }
        for (i = 0; i < this.size(); ++i) {
            this.getNode(i).setIndex(i);
        }
    }

    private TBGraphNode findOrCreateNode(TBPar par) {
        for (int i = 0; i < this.size(); ++i) {
            TBGraphNode gn = (TBGraphNode)this.elementAt(i);
            if (!par.equals(gn.getPar())) continue;
            return gn;
        }
        TBGraphNode gn = new TBGraphNode(par);
        this.addElement(gn);
        return gn;
    }

    public TBGraphNode getNode(int idx) {
        return (TBGraphNode)this.elementAt(idx);
    }

    public final void setInitCnt(int n) {
        this.initCnt = n;
    }

    public int getInitCnt() {
        return this.initCnt;
    }

    private boolean isInitNode(TBGraphNode aNode) {
        return aNode.getIndex() < this.getInitCnt();
    }

    public final void toString(StringBuffer sb, String padding) {
        for (int i = 0; i < this.size(); ++i) {
            TBGraphNode tnode = this.getNode(i);
            sb.append(padding);
            sb.append("Node " + i + ".\n");
            tnode.getPar().toString(sb, padding);
            sb.append(" --> ");
            for (int j = 0; j < tnode.nexts.size(); ++j) {
                sb.append(tnode.nextAt(j).getIndex() + " ");
            }
            sb.append("\n");
        }
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, "");
        return sb.toString();
    }

    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        sb.append("digraph TableauGraph {\n");
        sb.append("nodesep = 0.7\n");
        sb.append("rankdir=LR;\n");
        for (int i = 0; i < this.size(); ++i) {
            TBGraphNode node2 = this.getNode(i);
            sb.append(node2.toDotViz(this.isInitNode(node2)));
        }
        sb.append("}");
        return sb.toString();
    }
}

