/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tlc2.util.ObjectPoolStack;
import tlc2.util.ObjectStack;
import util.Assert;
import util.FileUtil;

public class DiskObjectStack
extends ObjectStack {
    private static final int BufSize = 8192;
    private final String filePrefix;
    protected Object[] buf1 = new Object[8192];
    protected Object[] buf2 = new Object[8192];
    protected Object[] buf = this.buf1;
    protected int index = 0;
    protected ObjectPoolStack diskStack;

    public DiskObjectStack(String diskdir, String name2) {
        this.filePrefix = diskdir + FileUtil.separator + name2;
        this.diskStack = new ObjectPoolStack(8192, this.filePrefix);
    }

    @Override
    final void enqueueInner(Object state) {
        if (this.index == 8192 && this.buf == this.buf2) {
            try {
                this.buf = this.diskStack.write(this.buf1);
                this.buf1 = this.buf2;
                this.buf2 = this.buf;
                this.index = 0;
            }
            catch (Exception e2) {
                Assert.fail(2175, new String[]{"stack", e2.getMessage()});
            }
        }
        this.buf[this.index++] = state;
    }

    @Override
    final Object dequeueInner() {
        if (this.buf == this.buf1 && this.index < 4096) {
            try {
                Object[] tempBuf = this.diskStack.read(this.buf);
                if (tempBuf != null) {
                    this.buf2 = this.buf1;
                    this.buf1 = tempBuf;
                    this.buf = this.buf2;
                }
            }
            catch (Exception e2) {
                Assert.fail(2174, new String[]{"stack", e2.getMessage()});
            }
        }
        return this.buf[--this.index];
    }

    @Override
    public final void beginChkpt() throws IOException {
        int i;
        String filename = this.filePrefix + ".tmp";
        ObjectOutputStream oos = FileUtil.newOBFOS(filename);
        oos.writeInt(this.len);
        int index1 = this.buf == this.buf1 ? this.index : 8192;
        int index2 = this.buf == this.buf1 ? 0 : this.index;
        oos.writeInt(index1);
        oos.writeInt(index2);
        for (i = 0; i < index1; ++i) {
            oos.writeObject(this.buf1[i]);
        }
        for (i = 0; i < index2; ++i) {
            oos.writeObject(this.buf2[i]);
        }
        oos.close();
    }

    @Override
    public final void commitChkpt() throws IOException {
        File oldChkpt = new File(this.filePrefix + ".chkpt");
        File newChkpt = new File(this.filePrefix + ".tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            String msg = "DiskObjectStack.commitChkpt: cannot delete " + oldChkpt;
            throw new IOException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recover() throws IOException {
        String filename = this.filePrefix + ".chkpt";
        ObjectInputStream ois = FileUtil.newOBFIS(filename);
        this.len = ois.readInt();
        int index1 = ois.readInt();
        int index2 = ois.readInt();
        try {
            int i;
            for (i = 0; i < index1; ++i) {
                this.buf1[i] = ois.readObject();
            }
            for (i = 0; i < index2; ++i) {
                this.buf2[i] = ois.readObject();
            }
        }
        catch (ClassNotFoundException e2) {
            Assert.fail(2126, e2.getMessage());
        }
        finally {
            ois.close();
        }
        if (index2 == 0) {
            this.buf = this.buf1;
            this.index = index1;
        } else {
            this.buf = this.buf2;
            this.index = index2;
        }
    }
}

