/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import util.FileUtil;

public class LongVec
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2406899362740899071L;
    protected long[] elementData;
    protected int elementCount;

    public LongVec() {
        this(10);
    }

    public LongVec(int initialCapacity) {
        this.elementCount = 0;
        this.elementData = new long[initialCapacity];
    }

    private LongVec(LongVec other) {
        this.elementCount = other.elementCount;
        this.elementData = Arrays.copyOfRange(other.elementData, 0, other.elementCount);
    }

    public final void addElement(long x) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = x;
    }

    public final long elementAt(int index2) {
        this.rangeCheck(index2);
        return this.elementData[index2];
    }

    public final long lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public final void removeElement(int index2) {
        this.rangeCheck(index2);
        this.elementData[index2] = this.elementData[this.elementCount - 1];
        --this.elementCount;
    }

    private void rangeCheck(int index2) {
        if (index2 >= this.elementCount) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index2));
        }
    }

    private String outOfBoundsMsg(int index2) {
        return "Index: " + index2 + ", Size: " + this.elementCount;
    }

    public final int size() {
        return this.elementCount;
    }

    private final void ensureCapacity(int minCapacity) {
        if (this.elementData.length < minCapacity) {
            int newCapacity = this.elementData.length + this.elementData.length;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            long[] oldBuffer = this.elementData;
            this.elementData = new long[newCapacity];
            System.arraycopy(oldBuffer, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void reset() {
        this.elementCount = 0;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.elementCount = ois.readInt();
        this.elementData = new long[this.elementCount];
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = ois.readLong();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.elementCount);
        for (int i = 0; i < this.elementCount; ++i) {
            oos.writeLong(this.elementData[i]);
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        if (this.elementCount != 0) {
            sb.append(this.elementData[0]);
        }
        for (int i = 1; i < this.elementCount; ++i) {
            sb.append(", ");
            sb.append(this.elementData[i]);
        }
        sb.append(">");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        LongVec vec2 = new LongVec(1000);
        vec2.addElement(1L);
        vec2.addElement(3L);
        vec2.addElement(5L);
        System.err.println(vec2.size());
        ObjectOutputStream oos = FileUtil.newOBFOS("XXX");
        oos.writeObject(vec2);
        ObjectInputStream ois = FileUtil.newOBFIS("XXX");
        LongVec vec1 = (LongVec)ois.readObject();
        System.err.println(vec1.size());
        System.err.println(vec1.elementAt(0));
        System.err.println(vec1.elementAt(1));
        System.err.println(vec1.elementAt(2));
    }

    private LongVec reverse0() {
        int left2 = 0;
        for (int right2 = this.elementData.length - 1; left2 < right2; ++left2, --right2) {
            long temp = this.elementData[left2];
            this.elementData[left2] = this.elementData[right2];
            this.elementData[right2] = temp;
        }
        return this;
    }

    public LongVec reverse() {
        return new LongVec(this).reverse0();
    }
}

