/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import tlc2.overrides.TLAPlusOperator;
import tlc2.value.IValue;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.SubsetValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class Json {
    public static final long serialVersionUID = 20210223L;

    @TLAPlusOperator(identifier="ToJson", module="Json", warn=false)
    public static StringValue toJson(IValue value) throws IOException {
        return new StringValue(Json.getNode(value).toString());
    }

    @TLAPlusOperator(identifier="ToJsonArray", module="Json", warn=false)
    public static StringValue toJsonArray(IValue value) throws IOException {
        return new StringValue(Json.getArrayNode(value).toString());
    }

    @TLAPlusOperator(identifier="ToJsonObject", module="Json", warn=false)
    public static StringValue toJsonObject(IValue value) throws IOException {
        return new StringValue(Json.getObjectNode(value).toString());
    }

    @TLAPlusOperator(identifier="ndJsonDeserialize", module="Json", warn=false)
    public static IValue ndDeserialize(StringValue path) throws IOException {
        ArrayList<Value> values = new ArrayList<Value>();
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(path.val.toString())));){
            String line = reader.readLine();
            while (line != null) {
                JsonElement node = JsonParser.parseString(line);
                values.add(Json.getValue(node));
                line = reader.readLine();
            }
        }
        return new TupleValue(values.toArray(new Value[0]));
    }

    @TLAPlusOperator(identifier="JsonDeserialize", module="Json", warn=false)
    public static IValue deserialize(StringValue path) throws IOException {
        JsonElement node = JsonParser.parseReader(new FileReader(new File(path.val.toString())));
        return Json.getValue(node);
    }

    @TLAPlusOperator(identifier="ndJsonSerialize", module="Json", warn=false)
    public static BoolValue ndSerialize(StringValue path, TupleValue value) throws IOException {
        File file = new File(path.val.toString());
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(path.val.toString())));){
            for (int i = 0; i < value.elems.length; ++i) {
                writer.write(Json.getNode(value.elems[i]).toString() + "\n");
            }
        }
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="JsonSerialize", module="Json", warn=false)
    public static BoolValue serialize(StringValue path, TupleValue value) throws IOException {
        File file = new File(path.val.toString());
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(path.val.toString())));){
            writer.write("[\n");
            for (int i = 0; i < value.elems.length; ++i) {
                writer.write(Json.getNode(value.elems[i]).toString());
                if (i >= value.elems.length - 1) continue;
                writer.write(",\n");
            }
            writer.write("\n]\n");
        }
        return BoolValue.ValTrue;
    }

    private static JsonElement getNode(IValue value) throws IOException {
        if (value instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)value);
        }
        if (value instanceof StringValue) {
            return new JsonPrimitive(((StringValue)value).val.toString());
        }
        if (value instanceof ModelValue) {
            return new JsonPrimitive(((ModelValue)value).val.toString());
        }
        if (value instanceof IntValue) {
            return new JsonPrimitive(((IntValue)value).val);
        }
        if (value instanceof BoolValue) {
            return new JsonPrimitive(((BoolValue)value).val);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        if (value instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)value);
        }
        if (value instanceof SetOfRcdsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfRcdsValue)value).toSetEnum());
        }
        if (value instanceof SetOfTuplesValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfTuplesValue)value).toSetEnum());
        }
        if (value instanceof SetOfFcnsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfFcnsValue)value).toSetEnum());
        }
        if (value instanceof SubsetValue) {
            return Json.getArrayNode((SetEnumValue)((SubsetValue)value).toSetEnum());
        }
        if (value instanceof IntervalValue) {
            return Json.getArrayNode((SetEnumValue)((IntervalValue)value).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static boolean isValidSequence(FcnRcdValue value) {
        if (value.intv != null) {
            return value.intv.low == 1 && value.intv.high == value.domain.length;
        }
        for (Value domain : value.domain) {
            if (domain instanceof IntValue) continue;
            return false;
        }
        value.normalize();
        for (int i = 0; i < value.domain.length; ++i) {
            if (((IntValue)value.domain[i]).val == i + 1) continue;
            return false;
        }
        return true;
    }

    private static JsonElement getObjectNode(IValue value) throws IOException {
        if (value instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)value);
        }
        if (value instanceof TupleValue) {
            return Json.getObjectNode((TupleValue)value);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static JsonElement getObjectNode(FcnRcdValue value) throws IOException {
        if (Json.isValidSequence(value)) {
            return Json.getArrayNode(value);
        }
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.domain.length; ++i) {
            Value domainValue = value.domain[i];
            if (domainValue instanceof StringValue) {
                jsonObject.add(((StringValue)domainValue).val.toString(), Json.getNode(value.values[i]));
                continue;
            }
            jsonObject.add(domainValue.toString(), Json.getNode(value.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(RecordValue value) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.names.length; ++i) {
            jsonObject.add(value.names[i].toString(), Json.getNode(value.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(TupleValue value) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < value.elems.length; ++i) {
            jsonObject.add(String.valueOf(i), Json.getNode(value.elems[i]));
        }
        return jsonObject;
    }

    private static JsonElement getArrayNode(IValue value) throws IOException {
        if (value instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)value);
        }
        if (value instanceof FcnRcdValue) {
            return Json.getArrayNode((FcnRcdValue)value);
        }
        if (value instanceof FcnLambdaValue) {
            return Json.getArrayNode((FcnRcdValue)((FcnLambdaValue)value).toFcnRcd());
        }
        if (value instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)value);
        }
        if (value instanceof SetOfRcdsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfRcdsValue)value).toSetEnum());
        }
        if (value instanceof SetOfTuplesValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfTuplesValue)value).toSetEnum());
        }
        if (value instanceof SetOfFcnsValue) {
            return Json.getArrayNode((SetEnumValue)((SetOfFcnsValue)value).toSetEnum());
        }
        if (value instanceof SubsetValue) {
            return Json.getArrayNode((SetEnumValue)((SubsetValue)value).toSetEnum());
        }
        if (value instanceof IntervalValue) {
            return Json.getArrayNode((SetEnumValue)((IntervalValue)value).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + value.getClass().getName());
    }

    private static JsonElement getArrayNode(TupleValue value) throws IOException {
        JsonArray jsonArray = new JsonArray(value.elems.length);
        for (int i = 0; i < value.elems.length; ++i) {
            jsonArray.add(Json.getNode(value.elems[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(FcnRcdValue value) throws IOException {
        if (!Json.isValidSequence(value)) {
            return Json.getObjectNode(value);
        }
        value.normalize();
        JsonArray jsonArray = new JsonArray(value.values.length);
        for (int i = 0; i < value.values.length; ++i) {
            jsonArray.add(Json.getNode(value.values[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(SetEnumValue value) throws IOException {
        value.normalize();
        Value[] values = value.elems.toArray();
        JsonArray jsonArray = new JsonArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            jsonArray.add(Json.getNode(values[i]));
        }
        return jsonArray;
    }

    private static Value getValue(JsonElement node) throws IOException {
        if (node.isJsonArray()) {
            return Json.getTupleValue(node);
        }
        if (node.isJsonObject()) {
            return Json.getRecordValue(node);
        }
        if (node.isJsonPrimitive()) {
            JsonPrimitive primitive = node.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return IntValue.gen(primitive.getAsInt());
            }
            if (primitive.isBoolean()) {
                return new BoolValue(primitive.getAsBoolean());
            }
            if (primitive.isString()) {
                return new StringValue(primitive.getAsString());
            }
        } else if (node.isJsonNull()) {
            return null;
        }
        throw new IOException("Cannot convert value: unsupported JSON value " + node.toString());
    }

    private static TupleValue getTupleValue(JsonElement node) throws IOException {
        ArrayList<Value> values = new ArrayList<Value>();
        JsonArray jsonArray = node.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            values.add(Json.getValue(jsonArray.get(i)));
        }
        return new TupleValue(values.toArray(new Value[0]));
    }

    private static RecordValue getRecordValue(JsonElement node) throws IOException {
        ArrayList<UniqueString> keys = new ArrayList<UniqueString>();
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry<String, JsonElement> entry : node.getAsJsonObject().entrySet()) {
            keys.add(UniqueString.uniqueStringOf(entry.getKey()));
            values.add(Json.getValue(entry.getValue()));
        }
        return new RecordValue(keys.toArray(new UniqueString[0]), values.toArray(new Value[0]), false);
    }
}

