/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import tlc2.tool.TLCState;

public final class SetOfStates {
    private TLCState[] states;
    private int count = 0;
    private int length;
    private int thresh;
    private int iteratorIndex = 0;

    public SetOfStates() {
        this(16);
    }

    public SetOfStates(int size) {
        this.length = size;
        this.thresh = this.length / 2;
        this.states = new TLCState[this.length];
    }

    public final void clear() {
        this.count = 0;
        this.states = new TLCState[this.length];
    }

    private final void grow() {
        TLCState[] old = this.states;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.states = new TLCState[this.length];
        for (int i = 0; i < old.length; ++i) {
            TLCState s = old[i];
            if (s == null) continue;
            this.put(s.fingerPrint(), s);
        }
    }

    public final boolean put(TLCState aState) {
        return this.put(aState.fingerPrint(), aState);
    }

    public final boolean put(long fingerprint, TLCState aState) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)fingerprint & Integer.MAX_VALUE) % this.length;
        while (true) {
            TLCState ent;
            if ((ent = this.states[loc]) == null) {
                this.states[loc] = aState;
                ++this.count;
                return false;
            }
            if (aState.equals(ent)) {
                return true;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int capacity() {
        return this.length;
    }

    public final int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < this.states.length; ++i) {
            TLCState tlcState = this.states[i];
            if (tlcState == null) continue;
            buf.append("<<");
            buf.append(tlcState.fingerPrint());
            buf.append(",");
            String toStr = tlcState.toString();
            buf.append(toStr.substring(0, toStr.length() - 1));
            buf.append(">>,\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public final TLCState next() {
        TLCState next = null;
        while ((next = this.states[this.iteratorIndex++]) == null) {
        }
        return next;
    }

    public void resetNext() {
        this.iteratorIndex = 0;
    }
}

