/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import tla2tex.Debug;

public class ResourceFileReader {
    private boolean done = false;
    private BufferedReader inputReader;
    private String name;

    public ResourceFileReader(String fileName) {
        this.name = fileName;
        Class<?> cl = null;
        try {
            cl = Class.forName("tla2tex.Token");
        }
        catch (ClassNotFoundException e) {
            Debug.ReportError("Java could not find class tla2tex.Token.  There \n    is probably something wrong with the way\n    TLA2TeX is installed");
        }
        InputStream input = cl.getResourceAsStream(fileName);
        if (input == null) {
            Debug.ReportError("TLATeX could not find its resource file " + fileName + ".\n    There is probably something wrong with the way\n    TLA2TeX is installed");
        }
        this.inputReader = new BufferedReader(new InputStreamReader(input));
    }

    public String getLine() {
        try {
            return this.inputReader.readLine();
        }
        catch (IOException e) {
            Debug.ReportError("Error reading the TLATeX resource file " + this.name + ".\n    You may be having file system problems");
            return null;
        }
    }

    public void close() {
        try {
            this.inputReader.close();
        }
        catch (IOException e) {
            Debug.ReportError("Error trying to close the TLATeX resource file " + this.name + ".\n    You may be having file system problems");
        }
    }
}

