/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.Action;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.BEGraph;
import tlc2.tool.liveness.BEGraphNode;
import tlc2.tool.liveness.BTGraphNode;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.ILiveChecker;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LiveException;
import tlc2.tool.liveness.Liveness;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.tool.liveness.TBPar;
import tlc2.util.FP64;
import tlc2.util.LongObjTable;
import tlc2.util.MemObjectStack;
import tlc2.util.ObjectStack;
import tlc2.util.SetOfStates;
import tlc2.util.Vect;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class LiveCheck1
implements ILiveCheck {
    private ITool myTool;
    private String metadir = "";
    private Action[] actions;
    private OrderOfSolution[] solutions;
    private BEGraph[] bgraphs;
    private StateVec stateTrace = null;
    private static final long MAX_FIRST = 0x2000000000000000L;
    private static final long MAX_SECOND = 0x5000000000000000L;
    private OrderOfSolution currentOOS = null;
    private PossibleErrorModel currentPEM = null;
    private ObjectStack comStack = null;
    private long firstNum = 1L;
    private long secondNum;
    private long startSecondNum = this.secondNum = 0x2000000000000001L;
    private long thirdNum;
    private long startThirdNum = this.thirdNum = 0x5000000000000001L;
    private long numFirstCom = this.secondNum;
    private long numSecondCom = this.thirdNum;
    private BEGraphNode initNode = null;

    public LiveCheck1(ITool tool) {
        this.myTool = tool;
        this.solutions = Liveness.processLiveness(this.myTool);
        this.bgraphs = new BEGraph[0];
    }

    public void init(ITool tool, Action[] acts, String mdir) {
        this.myTool = tool;
        this.metadir = mdir;
        this.actions = acts;
        this.solutions = Liveness.processLiveness(this.myTool);
        this.bgraphs = new BEGraph[this.solutions.length];
        for (int i = 0; i < this.solutions.length; ++i) {
            this.bgraphs[i] = new BEGraph(this.metadir, this.solutions[i].hasTableau());
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.bgraphs.length; ++i) {
            this.bgraphs[i].resetNumberField();
        }
    }

    private void initSccParams(OrderOfSolution os) {
        this.currentOOS = os;
        this.comStack = new MemObjectStack(this.metadir, "comstack");
        this.firstNum = 1L;
        this.secondNum = 0x2000000000000001L;
        this.thirdNum = 0x5000000000000001L;
        this.startSecondNum = this.secondNum;
        this.startThirdNum = this.thirdNum;
        this.numFirstCom = this.secondNum;
        this.numSecondCom = this.thirdNum;
    }

    Vect<BEGraphNode> constructBEGraph(ITool tool, OrderOfSolution os) {
        Vect<BEGraphNode> initNodes = new Vect<BEGraphNode>(1);
        int slen = os.getCheckState().length;
        int alen = os.getCheckAction().length;
        TLCState srcState = this.stateTrace.elementAt(0);
        long srcFP = srcState.fingerPrint();
        boolean[] checkStateRes = os.checkState(tool, srcState);
        boolean[] checkActionRes = os.checkAction(tool, srcState, srcState);
        if (!os.hasTableau()) {
            LongObjTable allNodes = new LongObjTable(127);
            BEGraphNode srcNode = new BEGraphNode(srcFP);
            srcNode.setCheckState(checkStateRes);
            srcNode.addTransition(srcNode, slen, alen, checkActionRes);
            allNodes.put(srcFP, srcNode);
            initNodes.addElement(srcNode);
            for (int i = 1; i < this.stateTrace.size(); ++i) {
                TLCState destState = this.stateTrace.elementAt(i);
                long destFP = destState.fingerPrint();
                BEGraphNode destNode = (BEGraphNode)allNodes.get(destFP);
                if (destNode == null) {
                    destNode = new BEGraphNode(destFP);
                    destNode.setCheckState(os.checkState(tool, srcState));
                    destNode.addTransition(destNode, slen, alen, os.checkAction(tool, destState, destState));
                    srcNode.addTransition(destNode, slen, alen, os.checkAction(tool, srcState, destState));
                    allNodes.put(destFP, destNode);
                } else if (!srcNode.transExists(destNode)) {
                    srcNode.addTransition(destNode, slen, alen, os.checkAction(tool, srcState, destState));
                }
                srcNode = destNode;
                srcState = destState;
            }
        } else {
            int i;
            LongObjTable allNodes = new LongObjTable(255);
            Vect<BTGraphNode> srcNodes = new Vect<BTGraphNode>();
            int initCnt = os.getTableau().getInitCnt();
            for (i = 0; i < initCnt; ++i) {
                TBGraphNode tnode = os.getTableau().getNode(i);
                if (!tnode.isConsistent(srcState, this.myTool)) continue;
                BTGraphNode destNode = new BTGraphNode(srcFP, tnode.getIndex());
                destNode.setCheckState(checkStateRes);
                initNodes.addElement(destNode);
                srcNodes.addElement(destNode);
                allNodes.put(FP64.Extend(srcFP, tnode.getIndex()), destNode);
            }
            for (i = 0; i < srcNodes.size(); ++i) {
                BEGraphNode srcNode = (BEGraphNode)srcNodes.elementAt(i);
                TBGraphNode tnode = srcNode.getTNode(os.getTableau());
                for (int j = 0; j < tnode.nextSize(); ++j) {
                    TBGraphNode tnode1 = tnode.nextAt(j);
                    long destFP = FP64.Extend(srcFP, tnode1.getIndex());
                    BEGraphNode destNode = (BEGraphNode)allNodes.get(destFP);
                    if (destNode == null) continue;
                    srcNode.addTransition(destNode, slen, alen, checkActionRes);
                }
            }
            for (i = 1; i < this.stateTrace.size(); ++i) {
                BEGraphNode destNode;
                long destFP;
                TBGraphNode tnode1;
                int k;
                TBGraphNode tnode;
                BEGraphNode srcNode;
                int j;
                Vect<BEGraphNode> destNodes = new Vect<BEGraphNode>();
                TLCState destState = this.stateTrace.elementAt(i);
                long destStateFP = destState.fingerPrint();
                checkStateRes = os.checkState(this.myTool, destState);
                checkActionRes = os.checkAction(tool, srcState, destState);
                for (j = 0; j < srcNodes.size(); ++j) {
                    srcNode = (BEGraphNode)srcNodes.elementAt(j);
                    tnode = srcNode.getTNode(os.getTableau());
                    for (k = 0; k < tnode.nextSize(); ++k) {
                        tnode1 = tnode.nextAt(k);
                        destFP = FP64.Extend(destStateFP, tnode1.getIndex());
                        destNode = (BEGraphNode)allNodes.get(destFP);
                        if (destNode == null) {
                            if (!tnode1.isConsistent(destState, this.myTool)) continue;
                            destNode = new BTGraphNode(destStateFP, tnode1.getIndex());
                            destNode.setCheckState(checkStateRes);
                            srcNode.addTransition(destNode, slen, alen, checkActionRes);
                            destNodes.addElement(destNode);
                            allNodes.put(destFP, destNode);
                            continue;
                        }
                        if (srcNode.transExists(destNode)) continue;
                        srcNode.addTransition(destNode, slen, alen, checkActionRes);
                    }
                }
                checkActionRes = os.checkAction(tool, destState, destState);
                for (j = 0; j < destNodes.size(); ++j) {
                    srcNode = (BEGraphNode)destNodes.elementAt(j);
                    tnode = srcNode.getTNode(os.getTableau());
                    for (k = 0; k < tnode.nextSize(); ++k) {
                        tnode1 = tnode.nextAt(k);
                        destFP = FP64.Extend(destStateFP, tnode1.getIndex());
                        destNode = (BEGraphNode)allNodes.get(destFP);
                        if (destNode == null) {
                            if (!tnode1.isConsistent(destState, this.myTool)) continue;
                            destNode = new BTGraphNode(destStateFP, tnode1.getIndex());
                            destNode.setCheckState(checkStateRes);
                            srcNode.addTransition(destNode, slen, alen, checkActionRes);
                            destNodes.addElement(destNode);
                            allNodes.put(destFP, destNode);
                            continue;
                        }
                        if (srcNode.transExists(destNode)) continue;
                        srcNode.addTransition(destNode, slen, alen, checkActionRes);
                    }
                }
                srcNodes = destNodes;
                srcState = destState;
            }
        }
        return initNodes;
    }

    @Override
    public void addInitState(ITool tool, TLCState state, long stateFP) {
        for (int soln = 0; soln < this.solutions.length; ++soln) {
            OrderOfSolution os = this.solutions[soln];
            BEGraph bgraph = this.bgraphs[soln];
            int slen = os.getCheckState().length;
            int alen = os.getCheckAction().length;
            boolean[] checkStateRes = os.checkState(tool, state);
            boolean[] checkActionRes = os.checkAction(tool, state, state);
            if (!os.hasTableau()) {
                BEGraphNode node = new BEGraphNode(stateFP);
                node.setCheckState(checkStateRes);
                bgraph.addInitNode(node);
                node.addTransition(node, slen, alen, checkActionRes);
                bgraph.allNodes.putBENode(node);
            } else {
                int initCnt = os.getTableau().getInitCnt();
                for (int i = 0; i < initCnt; ++i) {
                    TBGraphNode tnode = os.getTableau().getNode(i);
                    if (!tnode.isConsistent(state, this.myTool)) continue;
                    BTGraphNode destNode = new BTGraphNode(stateFP, tnode.getIndex());
                    destNode.setCheckState(checkStateRes);
                    bgraph.addInitNode(destNode);
                    bgraph.allNodes.putBTNode(destNode);
                    this.addNodesForStut(state, stateFP, destNode, checkStateRes, checkActionRes, os, bgraph);
                }
            }
            bgraph.allNodes.setDone(stateFP);
        }
    }

    @Override
    public void addNextState(ITool tool, TLCState s0, long fp0, SetOfStates nextStates) throws IOException {
        for (int i = 0; i < nextStates.size(); ++i) {
            TLCState s2 = nextStates.next();
            long fp2 = s2.fingerPrint();
            this.addNextState(tool, s0, fp0, s2, fp2);
        }
        nextStates.resetNext();
    }

    public synchronized void addNextState(ITool tool, TLCState s1, long fp1, TLCState s2, long fp2) {
        for (int soln = 0; soln < this.solutions.length; ++soln) {
            boolean[] checkActionRes;
            OrderOfSolution os = this.solutions[soln];
            BEGraph bgraph = this.bgraphs[soln];
            int slen = os.getCheckState().length;
            int alen = os.getCheckAction().length;
            if (!os.hasTableau()) {
                BEGraphNode node1 = bgraph.allNodes.getBENode(fp1);
                BEGraphNode node2 = bgraph.allNodes.getBENode(fp2);
                if (node2 == null) {
                    node2 = new BEGraphNode(fp2);
                    node2.setCheckState(os.checkState(tool, s2));
                    node1.addTransition(node2, slen, alen, os.checkAction(tool, s1, s2));
                    node2.addTransition(node2, slen, alen, os.checkAction(tool, s2, s2));
                    bgraph.allNodes.putBENode(node2);
                    continue;
                }
                if (node1.transExists(node2)) continue;
                checkActionRes = os.checkAction(tool, s1, s2);
                node1.addTransition(node2, slen, alen, checkActionRes);
                continue;
            }
            BTGraphNode[] srcNodes = bgraph.allNodes.getBTNode(fp1);
            if (srcNodes == null) continue;
            boolean[] checkStateRes = null;
            checkActionRes = os.checkAction(tool, s1, s2);
            boolean[] checkActionRes1 = null;
            for (int i = 0; i < srcNodes.length; ++i) {
                BTGraphNode srcNode = srcNodes[i];
                TBGraphNode tnode = os.getTableau().getNode(srcNode.getIndex());
                for (int j = 0; j < tnode.nextSize(); ++j) {
                    TBGraphNode tnode1 = tnode.nextAt(j);
                    BTGraphNode destNode = bgraph.allNodes.getBTNode(fp2, tnode1.getIndex());
                    if (destNode == null) {
                        if (!tnode1.isConsistent(s2, this.myTool)) continue;
                        destNode = new BTGraphNode(fp2, tnode1.getIndex());
                        if (checkStateRes == null) {
                            checkStateRes = os.checkState(tool, s2);
                        }
                        destNode.setCheckState(checkStateRes);
                        srcNode.addTransition(destNode, slen, alen, checkActionRes);
                        int idx = bgraph.allNodes.putBTNode(destNode);
                        if (checkActionRes1 == null) {
                            checkActionRes1 = os.checkAction(tool, s2, s2);
                        }
                        this.addNodesForStut(s2, fp2, destNode, checkStateRes, checkActionRes1, os, bgraph);
                        if (!bgraph.allNodes.isDone(idx)) continue;
                        this.addNextState(tool, s2, fp2, destNode, os, bgraph);
                        continue;
                    }
                    if (srcNode.transExists(destNode)) continue;
                    srcNode.addTransition(destNode, slen, alen, checkActionRes);
                }
            }
        }
    }

    private void addNodesForStut(TLCState state, long fp, BTGraphNode node, boolean[] checkState, boolean[] checkAction, OrderOfSolution os, BEGraph bgraph) {
        int slen = os.getCheckState().length;
        int alen = os.getCheckAction().length;
        TBGraphNode tnode = node.getTNode(os.getTableau());
        for (int i = 0; i < tnode.nextSize(); ++i) {
            TBGraphNode tnode1 = tnode.nextAt(i);
            BTGraphNode destNode = bgraph.allNodes.getBTNode(fp, tnode1.getIndex());
            if (destNode == null) {
                if (!tnode1.isConsistent(state, this.myTool)) continue;
                destNode = new BTGraphNode(fp, tnode1.getIndex());
                destNode.setCheckState(checkState);
                node.addTransition(destNode, slen, alen, checkAction);
                bgraph.allNodes.putBTNode(destNode);
                this.addNodesForStut(state, fp, destNode, checkState, checkAction, os, bgraph);
                continue;
            }
            node.addTransition(destNode, slen, alen, checkAction);
        }
    }

    private void addNextState(ITool tool, TLCState s, long fp, BTGraphNode node, OrderOfSolution os, BEGraph bgraph) {
        TBGraphNode tnode = node.getTNode(os.getTableau());
        int slen = os.getCheckState().length;
        int alen = os.getCheckAction().length;
        boolean[] checkStateRes = null;
        boolean[] checkActionRes = null;
        for (int i = 0; i < this.actions.length; ++i) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.myTool.getNextStates(curAction, s);
            for (int j = 0; j < nextStates.size(); ++j) {
                TLCState s1 = nextStates.elementAt(j);
                long fp1 = s1.fingerPrint();
                boolean[] checkActionRes1 = null;
                for (int k = 0; k < tnode.nextSize(); ++k) {
                    TBGraphNode tnode1 = tnode.nextAt(k);
                    BTGraphNode destNode = bgraph.allNodes.getBTNode(fp1, tnode1.getIndex());
                    if (destNode == null) {
                        if (!tnode1.isConsistent(s1, this.myTool)) continue;
                        destNode = new BTGraphNode(fp1, tnode1.getIndex());
                        if (checkStateRes == null) {
                            checkStateRes = os.checkState(tool, s1);
                        }
                        if (checkActionRes == null) {
                            checkActionRes = os.checkAction(tool, s, s1);
                        }
                        destNode.setCheckState(checkStateRes);
                        node.addTransition(destNode, slen, alen, checkActionRes);
                        if (checkActionRes1 == null) {
                            checkActionRes1 = os.checkAction(tool, s1, s1);
                        }
                        this.addNodesForStut(s1, fp1, destNode, checkStateRes, checkActionRes1, os, bgraph);
                        int idx = bgraph.allNodes.putBTNode(destNode);
                        if (!bgraph.allNodes.isDone(idx)) continue;
                        this.addNextState(tool, s1, fp1, destNode, os, bgraph);
                        continue;
                    }
                    if (node.transExists(destNode)) continue;
                    if (checkActionRes == null) {
                        checkActionRes = os.checkAction(tool, s, s1);
                    }
                    node.addTransition(destNode, slen, alen, checkActionRes);
                }
            }
        }
    }

    public synchronized void setDone(long fp) {
        for (int soln = 0; soln < this.solutions.length; ++soln) {
            this.bgraphs[soln].allNodes.setDone(fp);
        }
    }

    @Override
    public boolean doLiveCheck() {
        return true;
    }

    @Override
    public synchronized int check(ITool tool, boolean forceCheck) {
        int slen = this.solutions.length;
        if (slen == 0) {
            return 0;
        }
        for (int soln = 0; soln < slen; ++soln) {
            OrderOfSolution oos = this.solutions[soln];
            this.initSccParams(oos);
            BEGraph bgraph = this.bgraphs[soln];
            int numOfInits = bgraph.initSize();
            for (int i = 0; i < numOfInits; ++i) {
                this.initNode = bgraph.getInitNode(i);
                if (this.initNode.getNumber() != 0L) continue;
                this.checkSccs(this.initNode);
            }
        }
        return 0;
    }

    @Override
    public synchronized void checkTrace(ITool tool, StateVec trace) {
        this.stateTrace = trace;
        for (int soln = 0; soln < this.solutions.length; ++soln) {
            OrderOfSolution os = this.solutions[soln];
            Vect<BEGraphNode> initNodes = this.constructBEGraph(tool, os);
            this.initSccParams(os);
            int numOfInits = initNodes.size();
            for (int i = 0; i < numOfInits; ++i) {
                this.initNode = initNodes.elementAt(i);
                if (this.initNode.getNumber() != 0L) continue;
                this.checkSccs(this.initNode);
            }
        }
    }

    void printErrorTrace(BEGraphNode node) throws IOException {
        MP.printError(2116);
        MP.printError(2264);
        MemObjectStack cycleStack = new MemObjectStack(this.metadir, "cyclestack");
        int slen = this.currentOOS.getCheckState().length;
        int alen = this.currentOOS.getCheckAction().length;
        long lowNum = this.thirdNum - 1L;
        boolean[] AEStateRes = new boolean[this.currentPEM.AEState.length];
        boolean[] AEActionRes = new boolean[this.currentPEM.AEAction.length];
        boolean[] promiseRes = new boolean[this.currentOOS.getPromises().length];
        int cnt = AEStateRes.length + AEActionRes.length + promiseRes.length;
        BEGraphNode curNode = node;
        block0: while (cnt > 0) {
            curNode.setNumber(this.thirdNum);
            int cnt0 = cnt;
            while (true) {
                long num;
                BEGraphNode node1;
                int i;
                int i2;
                for (i2 = 0; i2 < this.currentPEM.AEState.length; ++i2) {
                    int idx = this.currentPEM.AEState[i2];
                    if (AEStateRes[i2] || !curNode.getCheckState(idx)) continue;
                    AEStateRes[i2] = true;
                    --cnt;
                }
                for (i2 = 0; i2 < this.currentOOS.getPromises().length; ++i2) {
                    LNEven promise = this.currentOOS.getPromises()[i2];
                    TBPar par = curNode.getTNode(this.currentOOS.getTableau()).getPar();
                    if (promiseRes[i2] || !par.isFulfilling(promise)) continue;
                    promiseRes[i2] = true;
                    --cnt;
                }
                if (cnt <= 0) continue block0;
                BEGraphNode nextNode1 = null;
                BEGraphNode nextNode2 = null;
                int cnt1 = cnt;
                for (i = 0; i < curNode.nextSize(); ++i) {
                    node1 = curNode.nextAt(i);
                    num = node1.getNumber();
                    if (lowNum <= num && num <= this.thirdNum) {
                        nextNode1 = node1;
                        for (int j = 0; j < this.currentPEM.AEAction.length; ++j) {
                            int idx = this.currentPEM.AEAction[j];
                            if (AEActionRes[j] || !curNode.getCheckAction(slen, alen, i, idx)) continue;
                            AEActionRes[j] = true;
                            --cnt;
                        }
                    }
                    if (cnt < cnt1) {
                        cycleStack.push(curNode);
                        curNode = node1;
                        ++this.thirdNum;
                        continue block0;
                    }
                    if (lowNum > num || num >= this.thirdNum) continue;
                    nextNode2 = node1;
                }
                if (cnt < cnt0) {
                    cycleStack.push(curNode);
                    curNode = nextNode1;
                    ++this.thirdNum;
                    continue block0;
                }
                block6: while (nextNode2 == null) {
                    curNode = (BEGraphNode)cycleStack.pop();
                    for (i = 0; i < curNode.nextSize(); ++i) {
                        node1 = curNode.nextAt(i);
                        num = node1.getNumber();
                        if (lowNum > num || num >= this.thirdNum) continue;
                        cycleStack.push(curNode);
                        nextNode2 = node1;
                        continue block6;
                    }
                }
                cycleStack.push(curNode);
                curNode = nextNode2;
                curNode.setNumber(this.thirdNum);
            }
        }
        curNode.setNumber(++this.thirdNum);
        block8: while (curNode != node) {
            boolean found = false;
            for (int i = 0; i < curNode.nextSize(); ++i) {
                BEGraphNode nextNode = curNode.nextAt(i);
                long num = nextNode.getNumber();
                if (lowNum > num || num >= this.thirdNum) continue;
                cycleStack.push(curNode);
                if (nextNode == node) break block8;
                found = true;
                curNode = nextNode;
                curNode.setNumber(this.thirdNum);
                break;
            }
            if (found) continue;
            curNode = (BEGraphNode)cycleStack.pop();
        }
        if (cycleStack.size() == 0) {
            cycleStack.push(curNode);
        }
        int stateNum = 0;
        BEGraphNode[] prefix = BEGraph.getPath(this.initNode, node);
        TLCStateInfo[] states = new TLCStateInfo[prefix.length];
        long fp = prefix[0].stateFP;
        TLCStateInfo sinfo = this.myTool.getState(fp);
        if (sinfo == null) {
            throw new EvalException(2123);
        }
        states[stateNum++] = sinfo;
        for (int i = 1; i < states.length; ++i) {
            long fp1 = prefix[i].stateFP;
            if (fp1 != fp) {
                sinfo = this.myTool.getState(fp1, sinfo.state);
                if (sinfo == null) {
                    throw new EvalException(2117);
                }
                states[stateNum++] = sinfo;
            }
            fp = fp1;
        }
        TLCState cycleState = null;
        for (int i = 0; i < stateNum; ++i) {
            StatePrinter.printInvariantViolationStateTraceState(states[i], cycleState, i + 1);
            cycleState = states[i].state;
        }
        TLCState lastState = cycleState;
        int cyclePos = stateNum;
        long[] fps = new long[cycleStack.size()];
        int idx = fps.length;
        while (idx > 0) {
            fps[--idx] = ((BEGraphNode)cycleStack.pop()).stateFP;
        }
        sinfo = states[stateNum - 1];
        for (int i = 1; i < fps.length; ++i) {
            if (fps[i] == fps[i - 1]) continue;
            sinfo = this.myTool.getState(fps[i], sinfo.state);
            if (sinfo == null) {
                throw new EvalException(2117);
            }
            StatePrinter.printInvariantViolationStateTraceState(sinfo, lastState, ++stateNum);
            lastState = sinfo.state;
        }
        if (node.stateFP == lastState.fingerPrint()) {
            StatePrinter.printStutteringState(stateNum);
        } else {
            sinfo = this.myTool.getState(cycleState.fingerPrint(), sinfo);
            assert (cycleState.equals(sinfo.state));
            StatePrinter.printBackToState(sinfo, cyclePos);
        }
    }

    void checkSubcomponent(BEGraphNode node) {
        int i;
        int slen = this.currentOOS.getCheckState().length;
        int alen = this.currentOOS.getCheckAction().length;
        boolean[] AEStateRes = new boolean[this.currentPEM.AEState.length];
        boolean[] AEActionRes = new boolean[this.currentPEM.AEAction.length];
        boolean[] promiseRes = new boolean[this.currentOOS.getPromises().length];
        MemObjectStack stack = new MemObjectStack(this.metadir, "subcomstack");
        node.incNumber();
        stack.push(node);
        while (stack.size() != 0) {
            int i2;
            BEGraphNode curNode = (BEGraphNode)stack.pop();
            for (int i3 = 0; i3 < this.currentPEM.AEState.length; ++i3) {
                if (AEStateRes[i3]) continue;
                int idx = this.currentPEM.AEState[i3];
                AEStateRes[i3] = curNode.getCheckState(idx);
            }
            int nsz = curNode.nextSize();
            for (i2 = 0; i2 < nsz; ++i2) {
                BEGraphNode node1 = curNode.nextAt(i2);
                long num = node1.getNumber();
                if (num >= this.thirdNum) {
                    for (int j = 0; j < this.currentPEM.AEAction.length; ++j) {
                        if (AEActionRes[j]) continue;
                        int idx = this.currentPEM.AEAction[j];
                        AEActionRes[j] = curNode.getCheckAction(slen, alen, i2, idx);
                    }
                }
                if (num != this.thirdNum) continue;
                node1.incNumber();
                stack.push(node1);
            }
            for (i2 = 0; i2 < this.currentOOS.getPromises().length; ++i2) {
                LNEven promise = this.currentOOS.getPromises()[i2];
                TBPar par = curNode.getTNode(this.currentOOS.getTableau()).getPar();
                if (!par.isFulfilling(promise)) continue;
                promiseRes[i2] = true;
            }
        }
        this.thirdNum += 2L;
        for (i = 0; i < this.currentPEM.AEState.length; ++i) {
            if (AEStateRes[i]) continue;
            return;
        }
        for (i = 0; i < this.currentPEM.AEAction.length; ++i) {
            if (AEActionRes[i]) continue;
            return;
        }
        for (i = 0; i < this.currentOOS.getPromises().length; ++i) {
            if (promiseRes[i]) continue;
            return;
        }
        try {
            this.printErrorTrace(node);
        }
        catch (IOException e) {
            MP.printError(1000, "printing an error trace", (Throwable)e);
        }
        throw new LiveException(2116, "LiveCheck: Found error trace.");
    }

    long checkSccs(BEGraphNode node) {
        long lowlink = this.firstNum++;
        node.setNumber(lowlink);
        this.comStack.push(node);
        int nsz = node.nextSize();
        for (int i = 0; i < nsz; ++i) {
            BEGraphNode destNode = node.nextAt(i);
            long destNum = destNode.getNumber();
            if (destNum == 0L) {
                destNum = this.checkSccs(destNode);
            }
            if (destNum >= lowlink) continue;
            lowlink = destNum;
        }
        if (lowlink == node.getNumber()) {
            this.checkComponent(node);
        }
        return lowlink;
    }

    void checkComponent(BEGraphNode node) {
        Vect<BEGraphNode> nodes = this.extractComponent(node);
        if (nodes != null) {
            PossibleErrorModel[] pems = this.currentOOS.getPems();
            for (int i = 0; i < pems.length; ++i) {
                this.currentPEM = pems[i];
                this.startSecondNum = this.secondNum;
                this.startThirdNum = this.thirdNum;
                for (int j = nodes.size() - 1; j >= 0; --j) {
                    BEGraphNode node1 = nodes.elementAt(j);
                    if (node1.getNumber() >= this.startThirdNum) continue;
                    this.checkSccs1(node1);
                }
            }
        }
    }

    Vect<BEGraphNode> extractComponent(BEGraphNode node) {
        BEGraphNode node1 = (BEGraphNode)this.comStack.pop();
        if (node == node1 && !node.transExists(node)) {
            node.setNumber(0x2000000000000000L);
            return null;
        }
        Vect<BEGraphNode> nodes = new Vect<BEGraphNode>();
        this.numFirstCom = this.secondNum++;
        this.numSecondCom = this.thirdNum;
        node1.setNumber(this.numFirstCom);
        nodes.addElement(node1);
        while (node != node1) {
            node1 = (BEGraphNode)this.comStack.pop();
            node1.setNumber(this.numFirstCom);
            nodes.addElement(node1);
        }
        return nodes;
    }

    long checkSccs1(BEGraphNode node) {
        long lowlink = this.secondNum++;
        node.setNumber(lowlink);
        this.comStack.push(node);
        int nsz = node.nextSize();
        for (int i = 0; i < nsz; ++i) {
            BEGraphNode destNode = node.nextAt(i);
            long destNum = destNode.getNumber();
            if (this.numFirstCom > destNum || !node.getCheckAction(this.currentOOS.getCheckState().length, this.currentOOS.getCheckAction().length, i, this.currentPEM.EAAction)) continue;
            if (destNum < this.startSecondNum || this.numSecondCom <= destNum && destNum < this.startThirdNum) {
                destNum = this.checkSccs1(destNode);
            }
            if (destNum >= lowlink) continue;
            lowlink = destNum;
        }
        if (lowlink == node.getNumber() && this.extractComponent1(node)) {
            this.checkSubcomponent(node);
        }
        return lowlink;
    }

    boolean extractComponent1(BEGraphNode node) {
        BEGraphNode node1 = (BEGraphNode)this.comStack.pop();
        if (node == node1 && !this.canStutter(node)) {
            node.setNumber(this.thirdNum++);
            return false;
        }
        node1.setNumber(this.thirdNum);
        while (node != node1) {
            node1 = (BEGraphNode)this.comStack.pop();
            node1.setNumber(this.thirdNum);
        }
        return true;
    }

    boolean canStutter(BEGraphNode node) {
        int slen = this.currentOOS.getCheckState().length;
        int alen = this.currentOOS.getCheckAction().length;
        for (int i = 0; i < node.nextSize(); ++i) {
            BEGraphNode node1 = node.nextAt(i);
            if (!node.equals(node1)) continue;
            long nodeNum = node.getNumber();
            return this.numFirstCom <= nodeNum && node.getCheckAction(slen, alen, i, this.currentPEM.EAAction);
        }
        return false;
    }

    @Override
    public int finalCheck(ITool tool) throws Exception {
        return this.check(tool, true);
    }

    @Override
    public String getMetaDir() {
        return this.metadir;
    }

    public ITool getTool() {
        return this.myTool;
    }

    @Override
    public IBucketStatistics getOutDegreeStatistics() {
        return new DummyBucketStatistics();
    }

    @Override
    public ILiveChecker getChecker(int idx) {
        return null;
    }

    @Override
    public int getNumChecker() {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void beginChkpt() throws IOException {
    }

    @Override
    public void commitChkpt() throws IOException {
    }

    @Override
    public void recover() throws IOException {
    }

    @Override
    public IBucketStatistics calculateInDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        return new DummyBucketStatistics();
    }

    @Override
    public IBucketStatistics calculateOutDegreeDiskGraphs(IBucketStatistics aGraphStats) throws IOException {
        return new DummyBucketStatistics();
    }
}

