/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class UnionValue
extends EnumerableValue
implements Enumerable {
    public final Value set;
    protected SetEnumValue realSet;

    public UnionValue(Value set) {
        this.set = set;
        this.realSet = null;
    }

    public UnionValue(Value val, CostModel cm) {
        this(val);
        this.cm = cm;
    }

    @Override
    public byte getKind() {
        return 20;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.realSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.convertAndCache();
            return this.realSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Value val;
            if (!(this.set instanceof Enumerable)) {
                Assert.fail("Attempted to check if:\n " + Values.ppr(elem.toString()) + "\nis an element of the non-enumerable set:\n " + Values.ppr(this.toString()));
            }
            ValueEnumeration Enum2 = ((Enumerable)((Object)this.set)).elements();
            while ((val = Enum2.nextElement()) != null) {
                if (!val.member(elem)) continue;
                return true;
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Value val;
            if (!(this.set instanceof Enumerable)) {
                Assert.fail("Attempted to check if the nonenumerable set:\n" + Values.ppr(this.toString()) + "\nis a finite set.");
            }
            ValueEnumeration Enum2 = ((Enumerable)((Object)this.set)).elements();
            while ((val = Enum2.nextElement()) != null) {
                if (val.isFinite()) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set:\n" + Values.ppr(this.toString()));
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set:\n " + Values.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.convertAndCache();
            return this.realSet.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.realSet != null && this.realSet != SetEnumValue.DummyEnum && this.realSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.realSet != null && this.realSet != SetEnumValue.DummyEnum) {
                this.realSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            this.set.deepNormalize();
            if (this.realSet == null) {
                this.realSet = SetEnumValue.DummyEnum;
            } else if (this.realSet != SetEnumValue.DummyEnum) {
                this.realSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static Value union(Value val) {
        boolean canCombine = val instanceof SetEnumValue;
        if (canCombine) {
            ValueVec elems = ((SetEnumValue)val).elems;
            for (int i = 0; i < elems.size(); ++i) {
                canCombine = canCombine && elems.elementAt(i) instanceof SetEnumValue;
            }
            if (canCombine) {
                ValueVec resElems = new ValueVec();
                SetEnumValue result = new SetEnumValue(resElems, false, val.getCostModel());
                for (int i = 0; i < elems.size(); ++i) {
                    ValueVec elems1 = ((SetEnumValue)elems.elementAt((int)i)).elems;
                    for (int j = 0; j < elems1.size(); ++j) {
                        Value elem = elems1.elementAt(j);
                        if (((Value)result).member(elem)) continue;
                        resElems.addElement(elem);
                    }
                }
                return result;
            }
        }
        return new UnionValue(val, val.getCostModel());
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        this.realSet.write(vos);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.realSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.realSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.realSet == null) {
            this.realSet = (SetEnumValue)this.toSetEnum();
        } else if (this.realSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = null;
            UnionValue unionValue = this;
            synchronized (unionValue) {
                if (this.realSet == SetEnumValue.DummyEnum) {
                    val = (SetEnumValue)this.toSetEnum();
                    val.deepNormalize();
                }
            }
            unionValue = this;
            synchronized (unionValue) {
                if (this.realSet == SetEnumValue.DummyEnum) {
                    this.realSet = val;
                }
            }
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.realSet != null && this.realSet != SetEnumValue.DummyEnum) {
            return this.realSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, false, this.cm);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            if (TLCGlobals.expand) {
                Value val = this.toSetEnum();
                return val.toString(sb, offset, swallow);
            }
            sb = sb.append("UNION(");
            sb = this.set.toString(sb, offset, swallow);
            sb.append(")");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.realSet == null || this.realSet == SetEnumValue.DummyEnum) {
                return new Enumerator();
            }
            return this.realSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration Enum;
        Value elemSet;
        ValueEnumeration elemSetEnum;

        public Enumerator() {
            if (!(UnionValue.this.set instanceof Enumerable)) {
                Assert.fail("Attempted to enumerate the nonenumerable set:\n" + Values.ppr(this.toString()));
            }
            this.Enum = ((Enumerable)((Object)UnionValue.this.set)).elements();
            this.elemSet = this.Enum.nextElement();
            if (this.elemSet != null) {
                if (!(this.elemSet instanceof Enumerable)) {
                    Assert.fail("Attempted to enumerate UNION(s), but some element of s is nonenumerable.");
                }
                this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
            }
        }

        @Override
        public final void reset() {
            this.Enum.reset();
            this.elemSet = this.Enum.nextElement();
            this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
        }

        @Override
        public final Value nextElement() {
            if (this.elemSet == null) {
                return null;
            }
            Value val = this.elemSetEnum.nextElement();
            if (val == null) {
                this.elemSet = this.Enum.nextElement();
                if (this.elemSet == null) {
                    return null;
                }
                if (!(this.elemSet instanceof Enumerable)) {
                    Assert.fail("Attempted to enumerate the nonenumerable set:\n" + Values.ppr(this.elemSet.toString()) + "\nwhen enumerating:\n" + Values.ppr(this.toString()));
                }
                this.elemSetEnum = ((Enumerable)((Object)this.elemSet)).elements();
                val = this.nextElement();
            }
            if (Value.coverage) {
                UnionValue.this.cm.incSecondary();
            }
            return val;
        }
    }
}

