/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.io.Serializable;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.SetCapValue;
import tlc2.value.impl.SetCupValue;
import tlc2.value.impl.SetDiffValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.SetPredValue;
import tlc2.value.impl.UnionValue;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.WrongInvocationException;

public abstract class Value
implements ValueConstants,
Serializable,
IValue {
    private static final String[] ValueImage = new String[]{"a Boolean value", "an integer", "a real", "a string", "a record", "a set of the form {e1, ... ,eN}", "a set of the form {x \\in S : expr}", "a tuple", "a function of the form  [x \\in S |-> expr]", "a function  of the form (d1 :> e1 @@ ... @@ dN :> eN)", "an operator", "a constant operator", "a java method", "a set of the form [S -> T]", "a set of the form [d1 : S1, ... , dN : SN]", "a cartesian product", "a set of the form SUBSET S", "a set of the form S \\ T", "a set of the form S \\cap T", "a set of the form S \\cup T", "a set of the form UNION  S", "a model value", "a special set constant", "a set of the form i..j", "an undefined value", "a value represented in lazy form", "a dummy for not-a-value"};
    protected static final boolean coverage = TLCGlobals.isCoverageEnabled();
    public transient CostModel cm = CostModel.DO_NOT_RECORD;
    private transient SemanticNode source = null;

    public abstract byte getKind();

    public String getKindString() {
        try {
            return ValueImage[this.getKind()];
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public abstract boolean member(Value var1);

    public abstract Value takeExcept(ValueExcept var1);

    public abstract Value takeExcept(ValueExcept[] var1);

    abstract boolean assignable(Value var1);

    public abstract Value normalize();

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        throw new WrongInvocationException("ValueOutputStream: Can not pickle the value\n" + Values.ppr(this.toString()));
    }

    @Override
    public IValue setCostModel(CostModel cm) {
        this.cm = cm;
        return this;
    }

    @Override
    public CostModel getCostModel() {
        return this.cm;
    }

    @Override
    public void setSource(SemanticNode semanticNode) {
        this.source = semanticNode;
    }

    @Override
    public SemanticNode getSource() {
        return this.source;
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    public boolean hasData() {
        return false;
    }

    public Object getData() {
        return null;
    }

    public Object setData(Object obj) {
        throw new WrongInvocationException("Value: Can not set data\n" + Values.ppr(this.toString()));
    }

    public final boolean isEmpty() {
        try {
            switch (this.getKind()) {
                case 5: {
                    SetEnumValue set = (SetEnumValue)this;
                    return set.elems.size() == 0;
                }
                case 23: {
                    IntervalValue intv = (IntervalValue)this;
                    return intv.size() == 0;
                }
                case 18: {
                    SetCapValue cap = (SetCapValue)this;
                    return cap.elements().nextElement() == null;
                }
                case 19: {
                    SetCupValue cup = (SetCupValue)this;
                    return cup.elements().nextElement() == null;
                }
                case 17: {
                    SetDiffValue diff = (SetDiffValue)this;
                    return diff.elements().nextElement() == null;
                }
                case 13: {
                    SetOfFcnsValue fcns = (SetOfFcnsValue)this;
                    return fcns.elements().nextElement() == null;
                }
                case 14: {
                    SetOfRcdsValue srv = (SetOfRcdsValue)this;
                    return srv.elements().nextElement() == null;
                }
                case 15: {
                    SetOfTuplesValue stv = (SetOfTuplesValue)this;
                    return stv.elements().nextElement() == null;
                }
                case 16: {
                    return false;
                }
                case 20: {
                    UnionValue uv = (UnionValue)this;
                    return uv.elements().nextElement() == null;
                }
                case 6: {
                    SetPredValue spv = (SetPredValue)this;
                    return spv.elements().nextElement() == null;
                }
            }
            Assert.fail("Shouldn't call isEmpty() on value " + Values.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public void deepNormalize() {
    }

    @Override
    public long fingerPrint(long fp) {
        try {
            Assert.fail("TLC has found a state in which the value of a variable contains " + Values.ppr(this.toString()));
            return 0L;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public IValue permute(IMVPerm perm) {
        try {
            Assert.fail("TLC has found a state in which the value of a variable contains " + Values.ppr(this.toString()));
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final int hashCode() {
        try {
            long fp = this.fingerPrint(FP64.New());
            int high = (int)(fp >> 32);
            int low = (int)fp;
            return high ^ low;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final Value select(Value[] path) {
        try {
            Value result = this;
            for (int i = 0; i < path.length; ++i) {
                Value elem;
                if (!(result instanceof Applicable)) {
                    Assert.fail("Attempted to apply EXCEPT construct to the value " + Values.ppr(result.toString()) + ".");
                }
                if ((result = ((Applicable)((Object)result)).select(elem = path[i])) != null) continue;
                return null;
            }
            return result;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public Value toSetEnum() {
        return null;
    }

    public Value toFcnRcd() {
        return null;
    }

    public Value toRcd() {
        return null;
    }

    public Value toTuple() {
        return null;
    }

    @Override
    public TLCState toState() {
        return null;
    }

    @Override
    public final String toString() {
        return this.toStringImpl("", true);
    }

    public final String toStringUnchecked() {
        return this.toStringImpl("", false);
    }

    @Override
    public String toUnquotedString() {
        return this.toString();
    }

    @Override
    public final String toString(String delim) {
        return this.toStringImpl(delim, true);
    }

    public final String toStringUnchecked(String delim) {
        return this.toStringImpl(delim, false);
    }

    private final String toStringImpl(String delim, boolean checked) {
        try {
            StringBuffer sb = this.toString(new StringBuffer(), 0, checked);
            sb.append(delim);
            return sb.toString();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }
}

