/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpDefOrLabelNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import util.UniqueString;
import util.WrongInvocationException;

public class LabelNode
extends ExprNode
implements ExploreNode,
OpDefOrLabelNode {
    UniqueString name;
    int arity;
    FormalParamNode[] params = null;
    public boolean isAssumeProve = false;
    LevelNode body = null;
    private Hashtable labels = null;
    ThmOrAssumpDefNode goal = null;
    int goalClause;
    public SymbolNode subExpressionOf = null;

    LabelNode(TreeNode tn, UniqueString nm, FormalParamNode[] pms, ThmOrAssumpDefNode gl, int clause, LevelNode bdy, boolean isAP) {
        super(29, tn);
        this.name = nm;
        this.params = pms;
        this.arity = pms.length;
        this.goal = gl;
        this.goalClause = clause;
        this.body = bdy;
        this.isAssumeProve = isAP;
    }

    LabelNode(LevelNode bdy) {
        super(29, SyntaxTreeNode.nullSTN);
        this.name = UniqueString.uniqueStringOf("nullLabelNode");
        this.params = new FormalParamNode[0];
        this.arity = 0;
        this.goal = null;
        this.body = bdy;
    }

    public UniqueString getName() {
        return this.name;
    }

    public void setLabels(Hashtable ht) {
        this.labels = ht;
    }

    @Override
    public LabelNode getLabel(UniqueString us) {
        if (this.labels == null) {
            return null;
        }
        return (LabelNode)this.labels.get(us);
    }

    @Override
    public boolean addLabel(LabelNode odn) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (this.labels.containsKey(odn)) {
            return false;
        }
        this.labels.put(odn.getName(), odn);
        return true;
    }

    @Override
    public LabelNode[] getLabels() {
        if (this.labels == null) {
            return new LabelNode[0];
        }
        Vector v = new Vector();
        Enumeration e = this.labels.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        LabelNode[] retVal = new LabelNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retVal[i] = (LabelNode)v.elementAt(i);
        }
        return retVal;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    public LevelNode getBody() {
        return this.body;
    }

    public SemanticNode getGoal() {
        return this.goal;
    }

    @Override
    public final boolean levelCheck(int iter) {
        if (this.levelChecked >= iter) {
            return true;
        }
        this.levelChecked = iter;
        boolean retVal = true;
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i] == null) continue;
            this.params[i].levelCheck(iter);
        }
        return this.body.levelCheck(iter) && retVal;
    }

    @Override
    public final int getLevel() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevel called for TheoremNode before levelCheck");
        }
        return this.body.getLevel();
    }

    @Override
    public final HashSet<SymbolNode> getLevelParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevelParams called for ThmNode before levelCheck");
        }
        return this.body.getLevelParams();
    }

    @Override
    public final HashSet<SymbolNode> getAllParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getAllParams called for ThmNode before levelCheck");
        }
        return this.body.getAllParams();
    }

    @Override
    public final SetOfLevelConstraints getLevelConstraints() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getLevelConstraints called for ThmNode before levelCheck");
        }
        return this.body.getLevelConstraints();
    }

    @Override
    public final SetOfArgLevelConstraints getArgLevelConstraints() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getArgLevelConstraints called for ThmNode before levelCheck");
        }
        return this.body.getArgLevelConstraints();
    }

    @Override
    public final HashSet<ArgLevelParam> getArgLevelParams() {
        if (this.levelChecked == 0) {
            throw new WrongInvocationException("getArgLevelParams called for ThmNode before levelCheck");
        }
        return this.body.getArgLevelParams();
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.body};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.body != null) {
            this.body.walkGraph(semNodesTable, visitor);
        }
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*LabelNode: " + super.toString(depth);
        ret = ret + Strings.indent(2, "\nname: " + this.name.toString());
        for (int i = 0; i < this.params.length; ++i) {
            ret = ret + Strings.indent(2, "\nparam[" + i + "]:" + Strings.indent(2, this.params[i].toString(depth - 1)));
        }
        ret = ret + Strings.indent(2, "\nisAssumeProve: " + this.isAssumeProve);
        ret = ret + Strings.indent(2, "\nBody:" + Strings.indent(2, this.body.toString(depth - 1)));
        if (this.labels != null) {
            ret = ret + "\n  Labels: ";
            Enumeration list = this.labels.keys();
            while (list.hasMoreElements()) {
                ret = ret + ((UniqueString)list.nextElement()).toString() + "  ";
            }
        } else {
            ret = ret + "\n  Labels: null";
        }
        if (this.subExpressionOf != null) {
            ret = ret + Strings.indent(2, "\nsubExpressionOf: " + Strings.indent(2, this.subExpressionOf.toString(1)));
        }
        if (this.goal != null) {
            ret = ret + "\n goal: " + Strings.indent(4, this.goal.toString(1)) + "\n goalClause: " + this.goalClause;
        }
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element ret = doc.createElement("LabelNode");
        ret.appendChild(this.appendText(doc, "uniquename", this.getName().toString()));
        ret.appendChild(this.appendText(doc, "arity", Integer.toString(this.getArity())));
        ret.appendChild(this.appendElement(doc, "body", this.body.export(doc, context)));
        Element arguments = doc.createElement("params");
        for (int i = 0; i < this.params.length; ++i) {
            arguments.appendChild(this.params[i].export(doc, context));
        }
        ret.appendChild(arguments);
        return ret;
    }
}

