/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.TLCRunner;
import tlc2.TestMPRecorder;
import tlc2.output.EC;
import tlc2.output.MP;
import tlc2.tool.CommonTestCase;
import tlc2.tool.ModelChecker;
import util.FileUtil;
import util.FilenameToStream;
import util.SimpleFilenameToStream;
import util.ToolIO;

public abstract class ModelCheckerTestCase
extends CommonTestCase {
    protected String path = "";
    protected String spec;
    protected String[] extraArguments = new String[0];
    protected TLC tlc;
    protected int actualExitStatus = -1;
    protected int expectedExitStatus = 0;

    public ModelCheckerTestCase(String spec2) {
        this(spec2, 0);
    }

    public ModelCheckerTestCase(String spec2, int exitStatus) {
        this(spec2, "", exitStatus);
    }

    public ModelCheckerTestCase(String spec2, String path) {
        this(spec2, path, 0);
    }

    public ModelCheckerTestCase(String spec2, String[] extraArguments) {
        this(spec2, "", extraArguments, 0);
    }

    public ModelCheckerTestCase(String spec2, String[] extraArguments, int exitStatus) {
        this(spec2, "", extraArguments, exitStatus);
    }

    public ModelCheckerTestCase(String spec2, String path, String[] extraArguments) {
        this(spec2, path, extraArguments, 0);
    }

    public ModelCheckerTestCase(String spec2, String path, String[] extraArguments, int exitStatus) {
        this(spec2, path, exitStatus);
        this.extraArguments = extraArguments;
    }

    public ModelCheckerTestCase(String spec2, String path, int exitStatus) {
        super(new TestMPRecorder());
        this.spec = spec2;
        this.path = path;
        this.expectedExitStatus = exitStatus;
    }

    protected void beforeSetUp() {
    }

    @Before
    public void setUp() {
        this.beforeSetUp();
        System.setProperty(ModelChecker.class.getName() + ".vetoCleanup", "true");
        System.setProperty("TLC_TRACE_EXPLORER_TIMESTAMP", "2000000000");
        System.setProperty("TLC_TRACE_EXPLORER_JSON_UNCOMMENTED", "true");
        try {
            ToolIO.setUserDir(BASE_PATH + this.path);
            MP.setRecorder(this.recorder);
            TLCGlobals.livenessThreshold = this.getLivenessThreshold();
            this.tlc = new TLC();
            this.tlc.setResolver(this.getResolver());
            ArrayList<String> args = new ArrayList<String>(6);
            if (!this.checkDeadLock()) {
                args.add("-deadlock");
            }
            if (this.getNumberOfThreads() == 1 && this.runWithDebugger()) {
                args.add("-debugger");
                args.add(String.format("nosuspend,port=%s,nohalt", 1025 + new Random().nextInt(64540)));
            }
            if (this.noGenerateSpec()) {
                args.add("-noGenerateSpecTE");
            }
            if (this.noRandomFPandSeed()) {
                args.add("-fp");
                args.add("0");
                args.add("-seed");
                args.add("1");
            }
            if (this.doCoverage()) {
                args.add("-coverage");
                args.add("1");
            }
            args.add("-workers");
            args.add(Integer.toString(this.getNumberOfThreads()));
            args.add("-checkpoint");
            args.add(Integer.toString(this.doCheckpoint()));
            if (this.doDump()) {
                args.add("-dump");
                args.add("dot");
                args.add("${metadir}" + FileUtil.separator + this.getClass().getCanonicalName() + ".dot");
            }
            args.addAll(Arrays.asList(this.extraArguments));
            args.add(this.spec);
            this.tlc.handleParameters(args.toArray(new String[args.size()]));
            int errorCode = this.tlc.process();
            this.actualExitStatus = EC.ExitStatus.errorConstantToExitStatus(errorCode);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected boolean noRandomFPandSeed() {
        return true;
    }

    protected boolean runWithDebugger() {
        return true;
    }

    protected double getLivenessThreshold() {
        return Double.MAX_VALUE;
    }

    protected FilenameToStream getResolver() {
        return new SimpleFilenameToStream();
    }

    protected boolean noGenerateSpec() {
        return false;
    }

    protected boolean doNotTestTESpec() {
        return false;
    }

    protected void beforeTearDown() {
    }

    protected void runTESpec() {
        if (this.noGenerateSpec() || this.recorder.getRecords(2217) == null || this.doNotTestTESpec()) {
            return;
        }
        Path sourcePath = Paths.get(System.getProperty("user.dir") + File.separator + this.spec + "_" + "TTrace" + "_2000000000" + ".tla", new String[0]);
        Path destPath = Paths.get(BASE_PATH + this.path + File.separator + this.spec + "_" + "TTrace" + "_2000000000" + ".tla", new String[0]);
        try {
            Files.move(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            Assert.fail((String)exception.getMessage());
        }
        sourcePath = Paths.get(System.getProperty("user.dir") + File.separator + this.spec + "_" + "TTrace" + "_2000000000" + ".cfg", new String[0]);
        destPath = Paths.get(BASE_PATH + this.path + File.separator + this.spec + "_" + "TTrace" + "_2000000000" + ".cfg", new String[0]);
        try {
            Files.move(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exception) {
            Assert.fail((String)exception.getMessage());
        }
        File outFile = new File(BASE_PATH, "test.out");
        ArrayList<String> runnerArgs = new ArrayList<String>(Arrays.asList(BASE_PATH + this.path + File.separator + this.spec + "_" + "TTrace" + "_2000000000"));
        runnerArgs.addAll(Arrays.asList(this.extraArguments));
        TLCRunner tlcRunner = new TLCRunner(runnerArgs, outFile);
        try {
            int errorCode = tlcRunner.run();
            if (errorCode != this.expectedExitStatus) {
                Assert.fail((String)String.format("The output of the generate TE spec TLC run was not the expected exit status (%d), it was %d instead.", this.expectedExitStatus, errorCode));
            }
        }
        catch (IOException exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.beforeTearDown();
        this.runTESpec();
        this.assertExitStatus();
    }

    protected void assertExitStatus() {
        Assert.assertEquals((long)this.expectedExitStatus, (long)this.actualExitStatus);
    }

    protected boolean doCoverage() {
        return true;
    }

    protected boolean checkDeadLock() {
        return false;
    }

    protected boolean doDump() {
        return true;
    }

    protected int doCheckpoint() {
        return 0;
    }

    protected int getNumberOfThreads() {
        return 1;
    }

    protected void setExitStatus(int exitStatus) {
        this.expectedExitStatus = exitStatus;
    }

    protected Object getField(Class<?> targetClass, String fieldName, Object instance) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

