/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.text.DecimalFormat;
import tlc2.util.Cache;

public class SimpleCache
implements Cache {
    private volatile long cacheHit = 1L;
    private volatile long cacheMiss = 1L;
    private final long mask;
    private final long[] cache;

    public SimpleCache() {
        this(10);
    }

    public SimpleCache(int size) {
        int capacity = 1 << size;
        this.mask = capacity - 1;
        this.cache = new long[capacity];
    }

    @Override
    public boolean hit(long fp) {
        int index = (int)(fp & this.mask);
        long hit = this.cache[index];
        if (hit == fp) {
            ++this.cacheHit;
            return true;
        }
        ++this.cacheMiss;
        this.cache[index] = fp;
        return false;
    }

    @Override
    public double getHitRatio() {
        return (double)this.cacheHit / (double)this.cacheMiss;
    }

    @Override
    public String getHitRatioAsString() {
        DecimalFormat df = new DecimalFormat("###,###.###");
        return df.format(this.getHitRatio());
    }

    @Override
    public long getHitRate() {
        return this.cacheHit;
    }
}

