/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import tlc2.output.MP;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.ITupleValue;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueInputStream;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.UniqueString;

public class TupleValue
extends Value
implements Applicable,
ITupleValue {
    public final Value[] elems;
    public static final TupleValue EmptyTuple = new TupleValue(new Value[0]);

    public TupleValue(Value[] elems) {
        this.elems = elems;
    }

    public TupleValue(Value v) {
        this(new Value[1]);
        this.elems[0] = v;
    }

    public TupleValue(Value v1, Value v2) {
        this(new Value[2]);
        this.elems[0] = v1;
        this.elems[1] = v2;
    }

    public TupleValue(Value[] elems, CostModel cm) {
        this(elems);
        this.cm = cm;
    }

    @Override
    public IValue getElem(int idx) {
        return this.elems[idx];
    }

    @Override
    public IValue[] getElems() {
        return this.elems;
    }

    @Override
    public final byte getKind() {
        return 7;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            TupleValue tv;
            TupleValue tupleValue = tv = obj instanceof Value ? (TupleValue)((Value)obj).toTuple() : null;
            if (tv == null) {
                return this.toFcnRcd().compareTo(obj);
            }
            int len = this.elems.length;
            int cmp = len - tv.elems.length;
            if (cmp == 0) {
                for (int i = 0; i < len && (cmp = this.elems[i].compareTo(tv.elems[i])) == 0; ++i) {
                }
            }
            return cmp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            TupleValue tv;
            TupleValue tupleValue = tv = obj instanceof Value ? (TupleValue)((Value)obj).toTuple() : null;
            if (tv == null) {
                return this.toFcnRcd().equals(obj);
            }
            int len = this.elems.length;
            if (len != tv.elems.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (this.elems[i].equals(tv.elems[i])) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check set membership in a tuple value.", this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            int idx;
            if (!(arg instanceof IntValue)) {
                Assert.fail("Attempted to access tuple at a non integral index: " + Values.ppr(arg.toString()), this.getSource());
            }
            if ((idx = ((IntValue)arg).val) <= 0 || idx > this.elems.length) {
                Assert.fail("Attempted to access index " + idx + " of tuple\n" + Values.ppr(this.toString()) + "\nwhich is out of bounds.", this.getSource());
            }
            return this.elems[idx - 1];
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            if (args.length != 1) {
                Assert.fail("Attempted to access tuple with " + args.length + " arguments when it expects 1.", this.getSource());
            }
            return this.apply(args[0], 0);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            int idx;
            if (!(arg instanceof IntValue)) {
                Assert.fail("Attempted to access tuple at a non integral index: " + Values.ppr(arg.toString()), this.getSource());
            }
            if ((idx = ((IntValue)arg).val) > 0 && idx <= this.elems.length) {
                return this.elems[idx - 1];
            }
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                int tlen = this.elems.length;
                Value[] newElems = new Value[tlen];
                Value arcVal = ex.path[ex.idx];
                if (arcVal instanceof IntValue) {
                    int idx = ((IntValue)arcVal).val - 1;
                    if (0 <= idx && idx < tlen) {
                        for (int i = 0; i < tlen; ++i) {
                            newElems[i] = this.elems[i];
                        }
                        ++ex.idx;
                        newElems[idx] = this.elems[idx].takeExcept(ex);
                    }
                    return new TupleValue(newElems);
                }
                MP.printWarning(2141, new String[]{Values.ppr(arcVal.toString())});
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Value val = this;
            for (int i = 0; i < exs.length; ++i) {
                val = ((Value)val).takeExcept(exs[i]);
            }
            return val;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            return new IntervalValue(1, this.size());
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        return this.elems.length;
    }

    @Override
    public final void deepNormalize() {
        try {
            for (int i = 0; i < this.elems.length; ++i) {
                this.elems[i].deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value toTuple() {
        return this;
    }

    @Override
    public final Value toRcd() {
        return this.size() == 0 ? RecordValue.EmptyRcd : super.toRcd();
    }

    @Override
    public final Value toFcnRcd() {
        IntervalValue intv = new IntervalValue(1, this.elems.length);
        if (coverage) {
            this.cm.incSecondary(this.elems.length);
        }
        return new FcnRcdValue(intv, this.elems, this.cm);
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            for (int i = 0; i < this.elems.length; ++i) {
                defined = defined && this.elems[i].isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        try {
            Value[] vals = new Value[this.elems.length];
            for (int i = 0; i < this.elems.length; ++i) {
                vals[i] = (Value)this.elems[i].deepCopy();
            }
            return new TupleValue(vals);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            boolean canAssign;
            boolean bl = canAssign = val instanceof TupleValue && this.elems.length == ((TupleValue)val).elems.length;
            if (!canAssign) {
                return false;
            }
            for (int i = 0; i < this.elems.length; ++i) {
                canAssign = canAssign && this.elems[i].assignable(((TupleValue)val).elems[i]);
            }
            return canAssign;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        int index = vos.put(this);
        if (index == -1) {
            vos.writeByte((byte)7);
            int len = this.elems.length;
            vos.writeNat(len);
            for (int i = 0; i < len; ++i) {
                this.elems[i].write(vos);
            }
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            int len = this.elems.length;
            fp = FP64.Extend(fp, (byte)9);
            fp = FP64.Extend(fp, len);
            for (int i = 0; i < len; ++i) {
                fp = FP64.Extend(fp, (byte)1);
                fp = FP64.Extend(fp, i + 1);
                fp = this.elems[i].fingerPrint(fp);
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            Value[] vals = new Value[this.elems.length];
            boolean changed = false;
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = (Value)this.elems[i].permute(perm);
                changed = changed || vals[i] != this.elems[i];
            }
            if (changed) {
                return new TupleValue(vals);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            sb.append("<<");
            int len = this.elems.length;
            if (len > 0) {
                sb = this.elems[0].toString(sb, offset, swallow);
            }
            for (int i = 1; i < len; ++i) {
                sb = sb.append(", ");
                sb = this.elems[i].toString(sb, offset, swallow);
            }
            sb.append(">>");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static IValue createFrom(IValueInputStream vos) throws IOException {
        int index = vos.getIndex();
        int len = vos.readNat();
        Value[] elems = new Value[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = (Value)vos.read();
        }
        TupleValue res = new TupleValue(elems);
        vos.assign(res, index);
        return res;
    }

    public static IValue createFrom(ValueInputStream vos, Map<String, UniqueString> tbl) throws IOException {
        int index = vos.getIndex();
        int len = vos.readNat();
        Value[] elems = new Value[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = (Value)vos.read(tbl);
        }
        TupleValue res = new TupleValue(elems);
        vos.assign(res, index);
        return res;
    }

    @Override
    public List<TLCVariable> getTLCVariables(TLCVariable prototype, Random rnd) {
        ArrayList<TLCVariable> nestedVars = new ArrayList<TLCVariable>(this.size());
        for (Value value : this.elems) {
            TLCVariable nested = prototype.newInstance(value.toString(), value, rnd);
            nested.setName(value.toString());
            nested.setValue(value.toString());
            nestedVars.add(nested);
        }
        return nestedVars;
    }
}

