/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.PrintWriter;
import tlc2.tool.Action;
import util.FileUtil;

public class DotActionWriter {
    protected final PrintWriter writer;
    protected final String fname;

    public DotActionWriter(String fname, String strict) throws IOException {
        this.fname = fname;
        this.writer = new PrintWriter(FileUtil.newBFOS(fname));
        this.writer.append(strict + "digraph ActionGraph {\n");
        this.writer.append("nodesep=0.35;\n");
        this.writer.flush();
    }

    public synchronized void write(Action action, int id) {
        this.writer.append(Integer.toString(id));
        this.writer.append(" [label=\"");
        this.writer.append(DotActionWriter.action2dot(action, id));
        this.writer.append("\"]");
        this.writer.append("\n");
    }

    public synchronized void write(Action from, int fromId, Action to, int toId) {
        this.write(from, fromId, to, toId, 0.0);
    }

    public synchronized void write(Action from, int fromId, Action to, int toId, double weight) {
        this.writer.append(Integer.toString(fromId));
        this.writer.append(" -> ");
        this.writer.append(Integer.toString(toId));
        if (weight == 0.0) {
            this.writer.append("[color=\"green\",style=dotted]");
        } else {
            this.writer.append(String.format("[penwidth=%s]", Double.toString(weight)));
        }
        this.writer.append(";\n");
    }

    protected static String action2dot(Action action, int id) {
        return action.getName().toString();
    }

    public void close() {
        this.writer.append("}");
        this.writer.close();
    }

    public void writeSubGraphStart(String key, String label) {
        this.writer.append(String.format("subgraph cluster_%s {\ncolor=\"white\"\nlabel=\"%s\"\n", key, label));
    }

    public void writeSubGraphEnd() {
        this.writer.append("}\n");
    }
}

